/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.sql;

import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.JndiConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PasswordReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.ConnectionReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JndiConnectionReadHandler
extends AbstractXmlReadHandler
implements ConnectionReadHandler {
    private StringReadHandler pathReadHandler;
    private StringReadHandler usernameReadHandler;
    private StringReadHandler passwordReadHandler;
    private JndiConnectionProvider connectionProvider;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("path".equals(tagName)) {
            this.pathReadHandler = new StringReadHandler();
            return this.pathReadHandler;
        }
        if ("username".equals(tagName)) {
            this.usernameReadHandler = new StringReadHandler();
            return this.usernameReadHandler;
        }
        if ("password".equals(tagName)) {
            this.passwordReadHandler = new PasswordReadHandler();
            return this.passwordReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        JndiConnectionProvider provider = new JndiConnectionProvider();
        if (this.pathReadHandler != null) {
            provider.setConnectionPath(this.pathReadHandler.getResult());
        }
        if (this.usernameReadHandler != null) {
            provider.setUsername(this.usernameReadHandler.getResult());
        }
        if (this.passwordReadHandler != null) {
            provider.setPassword(this.passwordReadHandler.getResult());
        }
        this.connectionProvider = provider;
    }

    public Object getObject() throws SAXException {
        return this.connectionProvider;
    }

    public ConnectionProvider getProvider() {
        return this.connectionProvider;
    }
}

