/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLReportDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.writer.ConnectionProviderWriteHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class SQLDataFactoryWriteHandler
implements BundleDataFactoryWriterHandler {
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        SQLReportDataFactory df = (SQLReportDataFactory)dataFactory;
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/sql-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for SQL-Data-Source");
        }
        OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
        DefaultTagDescription tagDescription = new DefaultTagDescription(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.tag-def.");
        XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/sql");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "sql-datasource", rootAttrs, false);
        AttributeList configAttrs = new AttributeList();
        configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "user-field", df.getUserField());
        configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "password-field", df.getPasswordField());
        configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "label-mapping", String.valueOf(df.isLabelMapping()));
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "config", configAttrs, true);
        this.writeConnectionInfo(bundle, state, xmlWriter, df.getConnectionProvider());
        String globalScript = df.getGlobalScript();
        String globalScriptLanguage = df.getGlobalScriptLanguage();
        if (!StringUtils.isEmpty((String)globalScript) && !StringUtils.isEmpty((String)globalScriptLanguage)) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "global-script", "language", globalScriptLanguage, false);
            xmlWriter.writeTextNormalized(globalScript, false);
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "query-definitions", false);
        String[] queryNames = df.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            String query = df.getQuery(queryName);
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "query", "name", queryName, false);
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "static-query", false);
            xmlWriter.writeTextNormalized(query, false);
            xmlWriter.writeCloseTag();
            String queryScriptLanguage = df.getScriptingLanguage(queryName);
            String queryScript = df.getScript(queryName);
            if (!(StringUtils.isEmpty((String)queryScript) || StringUtils.isEmpty((String)queryScriptLanguage) && StringUtils.isEmpty((String)globalScriptLanguage))) {
                if (StringUtils.isEmpty((String)queryScriptLanguage)) {
                    xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "script", false);
                } else {
                    xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "script", "language", queryScriptLanguage, false);
                }
                xmlWriter.writeTextNormalized(queryScript, false);
                xmlWriter.writeCloseTag();
            }
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
        xmlWriter.writeCloseTag();
        xmlWriter.close();
        return fileName;
    }

    private void writeConnectionInfo(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter xmlWriter, ConnectionProvider connectionProvider) throws IOException, BundleWriterException {
        ConnectionProviderWriteHandler handler;
        String configKey = "org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.writer.handler.sql-connection-provider." + connectionProvider.getClass().getName();
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        String value = globalConfig.getConfigProperty(configKey);
        if (value != null && (handler = (ConnectionProviderWriteHandler)ObjectUtilities.loadAndInstantiate((String)value, SQLReportDataFactory.class, ConnectionProviderWriteHandler.class)) != null) {
            handler.writeReport(bundle, state, xmlWriter, connectionProvider);
        }
    }
}

