/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.staticdata.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.NamedStaticDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class StaticDataFactoryWriterHandler
implements BundleDataFactoryWriterHandler {
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        NamedStaticDataFactory staticDataFactory = (NamedStaticDataFactory)dataFactory;
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/static-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for the Named-Static-Data-Source");
        }
        OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
        DefaultTagDescription tagDescription = new DefaultTagDescription(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.core.modules.parser.data.staticdata.tag-def.");
        XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        xmlWriter.writeXmlDeclaration("UTF-8");
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/static");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/static", "static-datasource", rootAttrs, false);
        String[] queryNames = staticDataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            String query = staticDataFactory.getQuery(queryName);
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/static", "query", "name", queryName, false);
            xmlWriter.writeTextNormalized(query, false);
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
        return fileName;
    }
}

