/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource;

import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.serializer.ClassComparator;

public class DataSourceCollector
implements DataSourceFactory {
    private final ArrayList factories = new ArrayList();
    private final ClassComparator comparator = new ClassComparator();
    private Configuration config;

    public void addFactory(DataSourceFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.factories.add(factory);
        if (this.getConfig() != null) {
            factory.configure(this.getConfig());
        }
    }

    public Iterator getFactories() {
        return this.factories.iterator();
    }

    public ObjectDescription getDataSourceDescription(String name) {
        for (int i = 0; i < this.factories.size(); ++i) {
            DataSourceFactory fact = (DataSourceFactory)this.factories.get(i);
            ObjectDescription o = fact.getDataSourceDescription(name);
            if (o == null) continue;
            return o.getInstance();
        }
        return null;
    }

    public String getDataSourceName(ObjectDescription od) {
        for (int i = 0; i < this.factories.size(); ++i) {
            DataSourceFactory fact = (DataSourceFactory)this.factories.get(i);
            String o = fact.getDataSourceName(od);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public ObjectDescription getDescriptionForClass(Class c) {
        for (int i = 0; i < this.factories.size(); ++i) {
            DataSourceFactory fact = (DataSourceFactory)this.factories.get(i);
            ObjectDescription o = fact.getDescriptionForClass(c);
            if (o == null) continue;
            return o.getInstance();
        }
        return null;
    }

    public ObjectDescription getSuperClassObjectDescription(Class d, ObjectDescription knownSuperClass) {
        for (int i = 0; i < this.factories.size(); ++i) {
            DataSourceFactory fact = (DataSourceFactory)this.factories.get(i);
            ObjectDescription od = fact.getSuperClassObjectDescription(d, knownSuperClass);
            if (od == null) continue;
            if (knownSuperClass == null) {
                knownSuperClass = od;
                continue;
            }
            if (!this.comparator.isComparable(knownSuperClass.getObjectClass(), od.getObjectClass()) || this.comparator.compare((Object)knownSuperClass.getObjectClass(), (Object)od.getObjectClass()) >= 0) continue;
            knownSuperClass = od;
        }
        if (knownSuperClass != null) {
            return knownSuperClass.getInstance();
        }
        return null;
    }

    public Iterator getRegisteredClasses() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.factories.size(); ++i) {
            ClassFactory f = (ClassFactory)this.factories.get(i);
            Iterator keys = f.getRegisteredClasses();
            while (keys.hasNext()) {
                list.add(keys.next());
            }
        }
        return list.iterator();
    }

    public void configure(Configuration config) {
        if (config == null) {
            throw new NullPointerException("The given configuration is null");
        }
        if (this.config != null) {
            return;
        }
        this.config = config;
        for (DataSourceFactory od : this.factories) {
            od.configure(config);
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Iterator getRegisteredNames() {
        return new ArrayList().iterator();
    }
}

