/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.objects;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.AbstractObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;
import org.pentaho.reporting.engine.classic.core.style.FontDefinition;

public class FontDefinitionObjectDescription
extends AbstractObjectDescription {
    private static final Log logger = LogFactory.getLog(FontDefinitionObjectDescription.class);
    public static final String FONT_ENCODING = "fontEncoding";
    public static final String FONT_NAME = "fontName";
    public static final String FONT_SIZE = "fontSize";
    public static final String BOLD = "bold";
    public static final String EMBEDDED_FONT = "embeddedFont";
    public static final String ITALIC = "italic";
    public static final String STRIKETHROUGH = "strikethrough";
    public static final String UNDERLINE = "underline";

    public FontDefinitionObjectDescription() {
        super(FontDefinition.class);
        this.setParameterDefinition(FONT_ENCODING, String.class);
        this.setParameterDefinition(FONT_NAME, String.class);
        this.setParameterDefinition(FONT_SIZE, Integer.class);
        this.setParameterDefinition(BOLD, Boolean.class);
        this.setParameterDefinition(EMBEDDED_FONT, Boolean.class);
        this.setParameterDefinition(ITALIC, Boolean.class);
        this.setParameterDefinition(STRIKETHROUGH, Boolean.class);
        this.setParameterDefinition(UNDERLINE, Boolean.class);
    }

    private boolean getBooleanParameter(String name) {
        Boolean bool = (Boolean)this.getParameter(name);
        if (bool == null) {
            return false;
        }
        return bool;
    }

    private int getIntegerParameter(String name) throws ObjectFactoryException {
        Integer i = (Integer)this.getParameter(name);
        if (i == null) {
            throw new ObjectFactoryException("Parameter " + name + " is not set");
        }
        return i;
    }

    public Object createObject() {
        try {
            String fontEncoding = (String)this.getParameter(FONT_ENCODING);
            String fontName = (String)this.getParameter(FONT_NAME);
            int fontSize = this.getIntegerParameter(FONT_SIZE);
            boolean bold = this.getBooleanParameter(BOLD);
            boolean embedded = this.getBooleanParameter(EMBEDDED_FONT);
            boolean italic = this.getBooleanParameter(ITALIC);
            boolean strike = this.getBooleanParameter(STRIKETHROUGH);
            boolean underline = this.getBooleanParameter(UNDERLINE);
            return new FontDefinition(fontName, fontSize, bold, italic, underline, strike, fontEncoding, embedded);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to create FontDefinition: ", (Throwable)e);
            return null;
        }
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof FontDefinition)) {
            throw new ObjectFactoryException("The given object is no FontDefinition.");
        }
        FontDefinition fdef = (FontDefinition)o;
        this.setParameter(FONT_ENCODING, fdef.getFontEncoding(null));
        this.setParameter(FONT_NAME, fdef.getFontName());
        this.setParameter(FONT_SIZE, new Integer(fdef.getFontSize()));
        this.setParameter(BOLD, this.getBoolean(fdef.isBold()));
        this.setParameter(EMBEDDED_FONT, this.getBoolean(fdef.isEmbeddedFont()));
        this.setParameter(ITALIC, this.getBoolean(fdef.isItalic()));
        this.setParameter(STRIKETHROUGH, this.getBoolean(fdef.isStrikeThrough()));
        this.setParameter(UNDERLINE, this.getBoolean(fdef.isUnderline()));
    }

    private Boolean getBoolean(boolean bool) {
        if (bool) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

