/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.objects;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.AbstractObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.objects.PathIteratorSegment;

public class GeneralPathObjectDescription
extends AbstractObjectDescription {
    private static final String SEGMENTS_NAME = "segments";
    private static final String WINDING_RULE_NAME = "windingRule";
    private static final String WINDING_RULE_EVEN_ODD = "wind-even-odd";
    private static final String WINDING_RULE_NON_ZERO = "wind-non-zero";
    private static final int MAX_POINTS = 6;

    public GeneralPathObjectDescription() {
        this(GeneralPath.class);
    }

    public GeneralPathObjectDescription(Class c) {
        super(c);
        if (!Shape.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Must be a shape instance");
        }
        this.setParameterDefinition(WINDING_RULE_NAME, String.class);
        this.setParameterDefinition(SEGMENTS_NAME, PathIteratorSegment[].class);
    }

    public Object createObject() {
        int wRule = this.parseWindingRule();
        if (wRule == -1) {
            return null;
        }
        PathIteratorSegment[] segments = (PathIteratorSegment[])this.getParameter(SEGMENTS_NAME);
        if (segments == null) {
            return null;
        }
        GeneralPath path = new GeneralPath();
        path.setWindingRule(wRule);
        block7: for (int i = 0; i < segments.length; ++i) {
            int segmentType = segments[i].getSegmentType();
            switch (segmentType) {
                case 4: {
                    path.closePath();
                    continue block7;
                }
                case 3: {
                    path.curveTo(segments[i].getX1(), segments[i].getY1(), segments[i].getX2(), segments[i].getY2(), segments[i].getX3(), segments[i].getY3());
                    continue block7;
                }
                case 1: {
                    path.lineTo(segments[i].getX1(), segments[i].getY1());
                    continue block7;
                }
                case 0: {
                    path.moveTo(segments[i].getX1(), segments[i].getY1());
                    continue block7;
                }
                case 2: {
                    path.quadTo(segments[i].getX1(), segments[i].getY1(), segments[i].getX2(), segments[i].getY2());
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Unexpected result from path iterator.");
                }
            }
        }
        return path;
    }

    private int parseWindingRule() {
        String windingRule = (String)this.getParameter(WINDING_RULE_NAME);
        int wRule = -1;
        if (windingRule == null) {
            return wRule;
        }
        if (windingRule.equals(WINDING_RULE_EVEN_ODD)) {
            wRule = 0;
        } else if (windingRule.equals(WINDING_RULE_NON_ZERO)) {
            wRule = 1;
        }
        return wRule;
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!this.getObjectClass().isAssignableFrom(o.getClass())) {
            throw new ObjectFactoryException("Class is not assignable");
        }
        Shape s = (Shape)o;
        PathIterator pi = s.getPathIterator(AffineTransform.getTranslateInstance(0.0, 0.0));
        if (pi.getWindingRule() == 0) {
            this.setParameter(WINDING_RULE_NAME, WINDING_RULE_EVEN_ODD);
        } else {
            this.setParameter(WINDING_RULE_NAME, WINDING_RULE_NON_ZERO);
        }
        float[] points = new float[6];
        ArrayList<PathIteratorSegment> segments = new ArrayList<PathIteratorSegment>();
        while (!pi.isDone()) {
            int type = pi.currentSegment(points);
            PathIteratorSegment seg = new PathIteratorSegment();
            switch (type) {
                case 4: {
                    seg.setSegmentType(4);
                    break;
                }
                case 3: {
                    seg.setSegmentType(3);
                    seg.setX1(points[0]);
                    seg.setY1(points[1]);
                    seg.setX2(points[2]);
                    seg.setY2(points[3]);
                    seg.setX3(points[4]);
                    seg.setY3(points[5]);
                    break;
                }
                case 1: {
                    seg.setSegmentType(1);
                    seg.setX1(points[0]);
                    seg.setY1(points[1]);
                    break;
                }
                case 0: {
                    seg.setSegmentType(0);
                    seg.setX1(points[0]);
                    seg.setY1(points[1]);
                    break;
                }
                case 2: {
                    seg.setSegmentType(2);
                    seg.setX1(points[0]);
                    seg.setY1(points[1]);
                    seg.setX2(points[2]);
                    seg.setY2(points[3]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected result from PathIterator.");
                }
            }
            segments.add(seg);
            pi.next();
        }
        this.setParameter(SEGMENTS_NAME, segments.toArray(new PathIteratorSegment[segments.size()]));
    }
}

