/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.objects;

import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.AbstractObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.objects.PathIteratorSegment;

public class PathIteratorSegmentObjectDescription
extends AbstractObjectDescription {
    private static final String SEG_MOVE_TO = "move-to";
    private static final String SEG_LINE_TO = "line-to";
    private static final String SEG_CUBIC_TO = "cubic-to";
    private static final String SEG_QUAD_TO = "quad-to";
    private static final String SEG_CLOSE = "close";

    public PathIteratorSegmentObjectDescription() {
        super(PathIteratorSegment.class);
        this.setParameterDefinition("x1", Float.TYPE);
        this.setParameterDefinition("y1", Float.TYPE);
        this.setParameterDefinition("x2", Float.TYPE);
        this.setParameterDefinition("y2", Float.TYPE);
        this.setParameterDefinition("x3", Float.TYPE);
        this.setParameterDefinition("y3", Float.TYPE);
        this.setParameterDefinition("segmentType", String.class);
    }

    public Object createObject() {
        PathIteratorSegment seg = new PathIteratorSegment();
        int segType = this.parseSegmentType((String)this.getParameter("segmentType"));
        if (segType == -1) {
            return null;
        }
        seg.setSegmentType(segType);
        seg.setX1(this.getFloatParameter("x1"));
        seg.setX2(this.getFloatParameter("x2"));
        seg.setX3(this.getFloatParameter("x3"));
        seg.setY1(this.getFloatParameter("y1"));
        seg.setY2(this.getFloatParameter("y2"));
        seg.setY3(this.getFloatParameter("y3"));
        return seg;
    }

    private int parseSegmentType(String segment) {
        if (segment == null) {
            return -1;
        }
        if (segment.equals(SEG_CLOSE)) {
            return 4;
        }
        if (segment.equals(SEG_CUBIC_TO)) {
            return 3;
        }
        if (segment.equals(SEG_LINE_TO)) {
            return 1;
        }
        if (segment.equals(SEG_MOVE_TO)) {
            return 0;
        }
        if (segment.equals(SEG_QUAD_TO)) {
            return 2;
        }
        return -1;
    }

    private String createSegmentType(int segment) throws IllegalArgumentException {
        switch (segment) {
            case 4: {
                return SEG_CLOSE;
            }
            case 3: {
                return SEG_CUBIC_TO;
            }
            case 1: {
                return SEG_LINE_TO;
            }
            case 0: {
                return SEG_MOVE_TO;
            }
            case 2: {
                return SEG_QUAD_TO;
            }
        }
        throw new IllegalArgumentException("The segment type is invalid.");
    }

    private float getFloatParameter(String name) {
        Float o = (Float)this.getParameter(name);
        if (o == null) {
            return 0.0f;
        }
        return o.floatValue();
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof PathIteratorSegment)) {
            throw new ObjectFactoryException("The given object is no PathIteratorSegment.");
        }
        PathIteratorSegment seg = (PathIteratorSegment)o;
        this.setParameter("segmentType", this.createSegmentType(seg.getSegmentType()));
        this.setParameter("x1", new Float(seg.getX1()));
        this.setParameter("x2", new Float(seg.getX2()));
        this.setParameter("x3", new Float(seg.getX3()));
        this.setParameter("y1", new Float(seg.getY1()));
        this.setParameter("y2", new Float(seg.getY2()));
        this.setParameter("y2", new Float(seg.getY3()));
    }
}

