/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.StyleKeyFactory;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public abstract class AbstractStyleKeyFactory
implements StyleKeyFactory {
    private static final Log logger = LogFactory.getLog(AbstractStyleKeyFactory.class);
    public static final String OBJECT_FACTORY_TAG = "object-factory";
    private final HashMap knownKeys = new HashMap();

    protected AbstractStyleKeyFactory() {
    }

    public void addKey(StyleKey key) {
        this.knownKeys.put(key.getName(), key);
    }

    public StyleKey getStyleKey(String name) {
        return (StyleKey)this.knownKeys.get(name);
    }

    public Object createBasicObject(StyleKey k, String value, Class c, ClassFactory fc) {
        if (k == null) {
            return null;
        }
        if (c == null) {
            throw new NullPointerException();
        }
        if (fc == null) {
            throw new NullPointerException("Class " + this.getClass());
        }
        ObjectDescription od = fc.getDescriptionForClass(c);
        if (od == null && (od = fc.getSuperClassObjectDescription(c, null)) == null) {
            return null;
        }
        od.setParameter("value", value);
        return od.createObject();
    }

    protected void loadFromClass(Class c) {
        Field[] fields = c.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!StyleKey.class.isAssignableFrom(f.getType()) || !Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers())) continue;
            try {
                this.addKey((StyleKey)f.get(null));
                continue;
            }
            catch (IllegalAccessException ex) {
                logger.warn((Object)"Unexpected Exception while loading stylekeys", (Throwable)ex);
            }
        }
    }

    public Iterator getRegisteredKeys() {
        return this.knownKeys.keySet().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractStyleKeyFactory)) {
            return false;
        }
        AbstractStyleKeyFactory abstractStyleKeyFactory = (AbstractStyleKeyFactory)o;
        return this.knownKeys.equals(abstractStyleKeyFactory.knownKeys);
    }

    public int hashCode() {
        return this.knownKeys.hashCode();
    }
}

