/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.filter.templates.ImageURLElementTemplate;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.AbstractTemplateDescription;

public class ImageURLElementTemplateDescription
extends AbstractTemplateDescription {
    private static final Log logger = LogFactory.getLog(ImageURLElementTemplateDescription.class);

    public ImageURLElementTemplateDescription(String name) {
        super(name, ImageURLElementTemplate.class, true);
    }

    public Object createObject() {
        ImageURLElementTemplate t = (ImageURLElementTemplate)super.createObject();
        if (this.isBaseURLNeeded(t.getContent()) && t.getBaseURL() == null) {
            String baseURL = this.getConfig().getConfigProperty("content-base");
            if (baseURL == null) {
                logger.warn((Object)"The image-URL will not be resolvable, as no BaseURL is defined.");
            } else {
                try {
                    URL bURL = new URL(baseURL);
                    t.setBaseURL(bURL);
                }
                catch (Exception e) {
                    logger.warn((Object)("BaseURL is invalid: " + baseURL), (Throwable)e);
                }
            }
        }
        return t;
    }

    private boolean isBaseURLNeeded(String content) {
        try {
            new URL(content);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

