/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.DataTarget;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.CompoundObjectReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class DataSourceReadHandler
extends CompoundObjectReadHandler {
    private DataSourceReadHandler childHandler;

    public DataSourceReadHandler() {
        super(null);
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        String typeName = attrs.getValue(this.getUri(), "type");
        if (typeName == null) {
            throw new ParseException("The datasource type must be specified", this.getRootHandler().getDocumentLocator());
        }
        DataSourceCollector fc = (DataSourceCollector)this.getRootHandler().getHelperObject("::datasource-factory");
        ObjectDescription od = fc.getDataSourceDescription(typeName);
        if (od == null) {
            throw new ParseException("The specified DataSource type is not defined", this.getLocator());
        }
        this.setObjectDescription(od);
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("datasource".equals(tagName)) {
            this.childHandler = new DataSourceReadHandler();
            return this.childHandler;
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    public Object getObject() {
        DataSource ds = (DataSource)super.getObject();
        if (this.childHandler != null && ds instanceof DataTarget) {
            DataTarget dt = (DataTarget)((Object)ds);
            dt.setDataSource((DataSource)this.childHandler.getObject());
        }
        return ds;
    }
}

