/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.StyleExpressionHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.DataSourceReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.TemplateReadHandler;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class ElementReadHandler
extends AbstractPropertyXmlReadHandler {
    private ArrayList styleExpressionHandlers;
    private XmlReadHandler dataSourceHandler;
    private Element element;

    public ElementReadHandler(Element element) {
        if (element == null) {
            throw new NullPointerException("Element given must not be null.");
        }
        this.element = element;
        this.styleExpressionHandlers = new ArrayList();
    }

    protected Element getElement() {
        return this.element;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        String name = attrs.getValue(this.getUri(), "name");
        if (name != null) {
            this.element.setName(name);
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("style".equals(tagName)) {
            return new StyleReadHandler(this.element.getStyle());
        }
        if ("style-expression".equals(tagName)) {
            StyleExpressionHandler styleExpressionHandler = new StyleExpressionHandler();
            this.styleExpressionHandlers.add(styleExpressionHandler);
            return styleExpressionHandler;
        }
        if ("datasource".equals(tagName)) {
            this.dataSourceHandler = new DataSourceReadHandler();
            return this.dataSourceHandler;
        }
        if ("template".equals(tagName)) {
            this.dataSourceHandler = new TemplateReadHandler(false);
            return this.dataSourceHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        if (this.dataSourceHandler != null) {
            this.element.setDataSource((DataSource)this.dataSourceHandler.getObject());
        }
        for (int i = 0; i < this.styleExpressionHandlers.size(); ++i) {
            StyleExpressionHandler handler = (StyleExpressionHandler)((Object)this.styleExpressionHandlers.get(i));
            StyleKey key = handler.getKey();
            if (handler.getKey() == null) continue;
            Expression expression = handler.getExpression();
            this.element.setStyleExpression(key, expression);
        }
        this.element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", this.getRootHandler().getSource());
    }

    public Object getObject() {
        return this.element;
    }
}

