/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.SubReportReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.FunctionsReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.IncludeReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ParameterMappingReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.elements.ElementFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.StyleKeyFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.ParserConfigReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.ReportConfigReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.ReportDescriptionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.StylesReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.TemplatesReadHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class ExtSubReportReadHandler
extends AbstractPropertyXmlReadHandler
implements SubReportReadHandler {
    public static final String ELEMENT_FACTORY_KEY = "::element-factory";
    public static final String STYLE_FACTORY_KEY = "::stylekey-factory";
    public static final String CLASS_FACTORY_KEY = "::class-factory";
    public static final String DATASOURCE_FACTORY_KEY = "::datasource-factory";
    public static final String TEMPLATE_FACTORY_KEY = "::template-factory";
    private ArrayList importParameters = new ArrayList();
    private ArrayList exportParameters = new ArrayList();
    private boolean disableRootTagWarning;

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) {
        super.init(rootHandler, uri, tagName);
        rootHandler.setHelperObject("property-expansion", (Object)Boolean.TRUE);
    }

    public void setDisableRootTagWarning(boolean disableWarning) {
        this.disableRootTagWarning = disableWarning;
    }

    public boolean isDisableRootTagWarning() {
        return this.disableRootTagWarning;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        String query;
        SubReport report;
        RootXmlReadHandler rootHandler = this.getRootHandler();
        Object maybeReport = rootHandler.getHelperObject("::Report");
        if (!(maybeReport instanceof SubReport)) {
            report = new SubReport();
            report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", this.getRootHandler().getSource());
        } else {
            report = (SubReport)maybeReport;
        }
        if (!ReportParserUtil.isIncluded(rootHandler) && (query = attrs.getValue(this.getUri(), "query")) != null) {
            report.setQuery(query);
        }
        if (rootHandler.getHelperObject(ELEMENT_FACTORY_KEY) == null) {
            ElementFactoryCollector elementFactory = new ElementFactoryCollector();
            rootHandler.setHelperObject(ELEMENT_FACTORY_KEY, (Object)elementFactory);
        }
        if (rootHandler.getHelperObject(STYLE_FACTORY_KEY) == null) {
            StyleKeyFactoryCollector styleKeyFactory = new StyleKeyFactoryCollector();
            rootHandler.setHelperObject(STYLE_FACTORY_KEY, (Object)styleKeyFactory);
        }
        if (rootHandler.getHelperObject(CLASS_FACTORY_KEY) == null) {
            ClassFactoryCollector classFactory = new ClassFactoryCollector();
            classFactory.configure((Configuration)rootHandler.getParserConfiguration());
            rootHandler.setHelperObject(CLASS_FACTORY_KEY, (Object)classFactory);
        }
        if (rootHandler.getHelperObject(DATASOURCE_FACTORY_KEY) == null) {
            DataSourceCollector dataSourceFactory = new DataSourceCollector();
            dataSourceFactory.configure((Configuration)rootHandler.getParserConfiguration());
            rootHandler.setHelperObject(DATASOURCE_FACTORY_KEY, (Object)dataSourceFactory);
        }
        if (rootHandler.getHelperObject(TEMPLATE_FACTORY_KEY) == null) {
            TemplateCollector templateFactory = new TemplateCollector();
            templateFactory.configure((Configuration)rootHandler.getParserConfiguration());
            rootHandler.setHelperObject(TEMPLATE_FACTORY_KEY, (Object)templateFactory);
        }
        report.setName(attrs.getValue(this.getUri(), "name"));
        rootHandler.setHelperObject("::Report", (Object)report);
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("parser-config".equals(tagName)) {
            return new ParserConfigReadHandler();
        }
        if ("report-config".equals(tagName)) {
            return new ReportConfigReadHandler();
        }
        if ("styles".equals(tagName)) {
            return new StylesReadHandler();
        }
        if ("templates".equals(tagName)) {
            return new TemplatesReadHandler();
        }
        if ("report-description".equals(tagName)) {
            return new ReportDescriptionReadHandler();
        }
        if ("functions".equals(tagName)) {
            return new FunctionsReadHandler(this.getSubReport());
        }
        if ("include".equals(tagName)) {
            return new IncludeReadHandler();
        }
        if ("import-parameter".equals(tagName)) {
            ParameterMappingReadHandler handler = new ParameterMappingReadHandler();
            this.importParameters.add(handler);
            return handler;
        }
        if ("export-parameter".equals(tagName)) {
            ParameterMappingReadHandler handler = new ParameterMappingReadHandler();
            this.exportParameters.add(handler);
            return handler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        ParameterMappingReadHandler handler;
        int i;
        super.doneParsing();
        SubReport report = this.getSubReport();
        for (i = 0; i < this.importParameters.size(); ++i) {
            handler = (ParameterMappingReadHandler)((Object)this.importParameters.get(i));
            report.addInputParameter(handler.getName(), handler.getAlias());
        }
        for (i = 0; i < this.exportParameters.size(); ++i) {
            handler = (ParameterMappingReadHandler)((Object)this.exportParameters.get(i));
            report.addExportParameter(handler.getAlias(), handler.getName());
        }
    }

    public Object getObject() {
        return this.getRootHandler().getHelperObject("::Report");
    }

    public SubReport getSubReport() {
        return (SubReport)this.getObject();
    }
}

