/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.CompoundObjectReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.ElementStyleSheetObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.StyleExtendsReadHandler;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheetCollection;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class StyleReadHandler
extends CompoundObjectReadHandler {
    private StyleSheetCollection styleSheetCollection;
    private ElementStyleSheet styleSheet;
    private boolean createStyle;

    public StyleReadHandler() {
        this((ElementStyleSheet)null);
    }

    public StyleReadHandler(ElementStyleSheet styleSheet) {
        super(new ElementStyleSheetObjectDescription());
        this.styleSheet = styleSheet;
        this.createStyle = styleSheet == null;
    }

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) {
        super.init(rootHandler, uri, tagName);
        ReportDefinition report = (ReportDefinition)rootHandler.getHelperObject("::Report");
        this.styleSheetCollection = report.getStyleSheetCollection();
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        if (this.createStyle) {
            String name = attrs.getValue(this.getUri(), "name");
            if (name == null) {
                throw new ParseException("Required attribute 'name' is missing.", this.getLocator());
            }
            this.styleSheet = this.styleSheetCollection.createStyleSheet(name);
        }
        ElementStyleSheetObjectDescription objectDescription = (ElementStyleSheetObjectDescription)this.getObjectDescription();
        objectDescription.init(this.getRootHandler(), this.styleSheet);
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("extends".equals(tagName)) {
            return new StyleExtendsReadHandler(this.styleSheetCollection, this.styleSheet);
        }
        if ("basic-key".equals(tagName)) {
            String name = atts.getValue(this.getUri(), "name");
            if (ElementStyleKeys.isLegacyKey(name)) {
                return new IgnoreAnyChildReadHandler();
            }
            return this.handleBasicObject(atts);
        }
        if ("compound-key".equals(tagName)) {
            String name = atts.getValue(this.getUri(), "name");
            if (ElementStyleKeys.isLegacyKey(name)) {
                return new IgnoreAnyChildReadHandler();
            }
            return this.handleCompoundObject(atts);
        }
        return null;
    }

    public Object getObject() {
        return this.styleSheet;
    }
}

