/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ObjectWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class DataSourceWriter
extends ObjectWriter {
    private DataSourceCollector dataSourceCollector;

    public DataSourceWriter(ReportWriterContext reportWriter, DataSource baseObject, ObjectDescription objectDescription, XmlWriter indent) throws ReportWriterException {
        super(reportWriter, baseObject, objectDescription, indent);
        if (!DataSource.class.isAssignableFrom(objectDescription.getObjectClass())) {
            throw new IllegalArgumentException("Expect a datasource description, but got " + objectDescription.getObjectClass());
        }
        this.dataSourceCollector = this.getReportWriter().getDataSourceCollector();
    }

    protected void writeParameter(String name) throws IOException, ReportWriterException {
        if (!"dataSource".equals(name)) {
            super.writeParameter(name);
            return;
        }
        DataSource ds = (DataSource)this.getObjectDescription().getParameter(name);
        ObjectDescription dsDesc = this.getParameterDescription(name);
        String dsname = this.dataSourceCollector.getDataSourceName(dsDesc);
        if (dsname == null) {
            throw new ReportWriterException("The datasource type is not registered: " + ds.getClass());
        }
        XmlWriter writer = this.getXmlWriter();
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "datasource", "type", dsname, false);
        DataSourceWriter dsWriter = new DataSourceWriter(this.getReportWriter(), ds, dsDesc, writer);
        dsWriter.write();
        writer.writeCloseTag();
    }
}

