/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.function.FormulaFunction;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ObjectWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.ReportProperties;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class FunctionsWriter
extends AbstractXMLDefinitionWriter {
    private static final Log logger = LogFactory.getLog(FunctionsWriter.class);
    public static final String FUNCTION_TAG = "function";
    public static final String EXPRESSION_TAG = "expression";
    public static final String STYLE_EXPRESSION_TAG = "style-expression";
    public static final String PROPERTY_REF_TAG = "property-ref";

    public FunctionsWriter(ReportWriterContext reportWriter, XmlWriter indentLevel) {
        super(reportWriter, indentLevel);
    }

    public void write() throws IOException, ReportWriterException {
        if (this.shouldWriteFunctions()) {
            XmlWriter writer = this.getXmlWriter();
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "functions", false);
            this.writePropertyRefs();
            this.writeExpressions(this.getReport().getExpressions());
            writer.writeCloseTag();
        }
    }

    private boolean shouldWriteFunctions() {
        AbstractReportDefinition report = this.getReport();
        if (report.getProperties().containsMarkedProperties()) {
            return true;
        }
        return report.getExpressions().size() != 0;
    }

    public void writeExpressions(ExpressionCollection exp) throws IOException {
        for (int i = 0; i < exp.size(); ++i) {
            Expression expression = exp.getExpression(i);
            this.writeExpression(expression);
        }
    }

    private void writeExpression(Expression expression) throws IOException {
        XmlWriter writer = this.getXmlWriter();
        if (expression instanceof FormulaExpression) {
            FormulaExpression fe = (FormulaExpression)expression;
            AttributeList properties = new AttributeList();
            if (expression.getName() != null) {
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "name", expression.getName());
            }
            properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "formula", fe.getFormula());
            if (expression.getDependencyLevel() > 0) {
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "deplevel", String.valueOf(expression.getDependencyLevel()));
            }
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", EXPRESSION_TAG, properties, true);
            return;
        }
        if (expression instanceof FormulaFunction) {
            FormulaFunction fe = (FormulaFunction)expression;
            AttributeList properties = new AttributeList();
            if (expression.getName() != null) {
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "name", expression.getName());
            }
            properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "formula", fe.getFormula());
            properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "initial", fe.getInitial());
            if (expression.getDependencyLevel() > 0) {
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "deplevel", String.valueOf(expression.getDependencyLevel()));
            }
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", EXPRESSION_TAG, properties, true);
            return;
        }
        try {
            BeanUtility bu = new BeanUtility(expression);
            String[] propertyNames = bu.getProperties();
            if (propertyNames.length == 0) {
                AttributeList properties = new AttributeList();
                if (expression.getName() != null) {
                    properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "name", expression.getName());
                }
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "class", expression.getClass().getName());
                if (expression.getDependencyLevel() > 0) {
                    properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "deplevel", String.valueOf(expression.getDependencyLevel()));
                }
                writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", EXPRESSION_TAG, properties, true);
            } else {
                AttributeList properties = new AttributeList();
                if (expression.getName() != null) {
                    properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "name", expression.getName());
                }
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "class", expression.getClass().getName());
                if (expression.getDependencyLevel() > 0) {
                    properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "deplevel", String.valueOf(expression.getDependencyLevel()));
                }
                writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", EXPRESSION_TAG, properties, false);
                this.writeExpressionParameters(propertyNames, bu);
                writer.writeCloseTag();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to write the expression", (Throwable)e);
            throw new IOException("Unable to extract or write properties.");
        }
    }

    public void writeStyleExpression(Expression expression, StyleKey styleKey) throws IOException {
        if (expression instanceof FormulaExpression) {
            FormulaExpression fe = (FormulaExpression)expression;
            AttributeList properties = new AttributeList();
            properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "style-key", styleKey.getName());
            properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "formula", fe.getFormula());
            if (expression.getDependencyLevel() > 0) {
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "deplevel", String.valueOf(expression.getDependencyLevel()));
            }
            this.getXmlWriter().writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", STYLE_EXPRESSION_TAG, properties, true);
            return;
        }
        if (expression instanceof FormulaFunction) {
            FormulaFunction fe = (FormulaFunction)expression;
            AttributeList properties = new AttributeList();
            properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "style-key", styleKey.getName());
            properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "formula", fe.getFormula());
            properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "initial", fe.getInitial());
            if (expression.getDependencyLevel() > 0) {
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "deplevel", String.valueOf(expression.getDependencyLevel()));
            }
            this.getXmlWriter().writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", STYLE_EXPRESSION_TAG, properties, true);
            return;
        }
        try {
            BeanUtility bu = new BeanUtility(expression);
            String[] propertyNames = bu.getProperties();
            if (propertyNames.length == 0) {
                AttributeList properties = new AttributeList();
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "style-key", styleKey.getName());
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "class", expression.getClass().getName());
                if (expression.getDependencyLevel() > 0) {
                    properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "deplevel", String.valueOf(expression.getDependencyLevel()));
                }
                this.getXmlWriter().writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", STYLE_EXPRESSION_TAG, properties, true);
            } else {
                AttributeList properties = new AttributeList();
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "style-key", styleKey.getName());
                properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "class", expression.getClass().getName());
                if (expression.getDependencyLevel() > 0) {
                    properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "deplevel", String.valueOf(expression.getDependencyLevel()));
                }
                this.getXmlWriter().writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", STYLE_EXPRESSION_TAG, properties, false);
                this.writeExpressionParameters(propertyNames, bu);
                this.getXmlWriter().writeCloseTag();
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to extract or write properties.");
        }
    }

    private void writeExpressionParameters(String[] propertyNames, BeanUtility beanUtility) throws IOException, BeanException {
        XmlWriter writer = this.getXmlWriter();
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "properties", false);
        for (int i = 0; i < propertyNames.length; ++i) {
            String key = propertyNames[i];
            if ("name".equals(key) || "dependencyLevel".equals(key) || "runtime".equals(key) || "active".equals(key) || "preserve".equals(key)) continue;
            Object property = beanUtility.getProperty(key);
            Class propertyType = beanUtility.getPropertyType(key);
            String value = beanUtility.getPropertyAsString(key);
            if (value == null || property == null) continue;
            AttributeList attList = new AttributeList();
            attList.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "name", key);
            if (!BeanUtility.isSameType(propertyType, property.getClass())) {
                attList.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "class", property.getClass().getName());
            }
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "property", attList, false);
            writer.writeTextNormalized(value, false);
            writer.writeCloseTag();
        }
        writer.writeCloseTag();
    }

    private void writePropertyRefs() throws IOException, ReportWriterException {
        ReportProperties reportProperties = this.getReport().getProperties();
        Iterator keys = reportProperties.keys();
        XmlWriter writer = this.getXmlWriter();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            Object value = reportProperties.get(name);
            if (value == null) {
                writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", PROPERTY_REF_TAG, "name", name, true);
                continue;
            }
            String svalue = null;
            try {
                svalue = ConverterRegistry.toAttributeValue(value);
            }
            catch (BeanException e) {
                logger.warn((Object)("Unable to convert the given property value into a simple bean for property '" + name + '\''));
            }
            if (svalue == null) {
                writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", PROPERTY_REF_TAG, "name", name, true);
                continue;
            }
            AttributeList properties = new AttributeList();
            properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "name", name);
            properties.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "class", value.getClass().getName());
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", PROPERTY_REF_TAG, properties, false);
            writer.writeTextNormalized(svalue, false);
            writer.writeCloseTag();
        }
    }

    private void writeObjectDescription(ObjectDescription od, Object o) throws IOException, ReportWriterException {
        try {
            od.setParameterFromObject(o);
        }
        catch (Exception e) {
            throw new ReportWriterException("Unable to write the report property reference", e);
        }
        if (this.isBasicObject(od)) {
            String value = (String)od.getParameter("value");
            if (value != null) {
                XmlWriter writer = this.getXmlWriter();
                writer.writeTextNormalized(value, false);
            }
        } else {
            ObjectWriter objectWriter = new ObjectWriter(this.getReportWriter(), o, od, this.getXmlWriter());
            objectWriter.write();
        }
    }

    private boolean isBasicObject(ObjectDescription od) {
        Iterator odNames = od.getParameterNames();
        if (!odNames.hasNext()) {
            return false;
        }
        String param = (String)odNames.next();
        if (odNames.hasNext()) {
            return false;
        }
        return "value".equals(param) && od.getParameterDefinition("value").equals(String.class);
    }
}

