/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ParserConfigWriter
extends AbstractXMLDefinitionWriter {
    private static final Log logger = LogFactory.getLog(ParserConfigWriter.class);
    public static final String STYLEKEY_FACTORY_TAG = "stylekey-factory";
    public static final String TEMPLATE_FACTORY_TAG = "template-factory";
    public static final String OBJECT_FACTORY_TAG = "object-factory";
    public static final String DATADEFINITION_FACTORY_TAG = "datadefinition-factory";
    public static final String DATASOURCE_FACTORY_TAG = "datasource-factory";
    public static final String ELEMENT_FACTORY_TAG = "element-factory";

    public ParserConfigWriter(ReportWriterContext reportWriter, XmlWriter xmlWriter) {
        super(reportWriter, xmlWriter);
    }

    public void write() throws IOException {
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "parser-config", false);
        this.writeFactory(OBJECT_FACTORY_TAG, this.filterFactories(this.getReportWriter().getClassFactoryCollector().getFactories()));
        this.writeFactory(ELEMENT_FACTORY_TAG, this.filterFactories(this.getReportWriter().getElementFactoryCollector().getFactories()));
        this.writeFactory(STYLEKEY_FACTORY_TAG, this.filterFactories(this.getReportWriter().getStyleKeyFactoryCollector().getFactories()));
        this.writeFactory(TEMPLATE_FACTORY_TAG, this.filterFactories(this.getReportWriter().getTemplateCollector().getFactories()));
        this.writeFactory(DATASOURCE_FACTORY_TAG, this.filterFactories(this.getReportWriter().getDataSourceCollector().getFactories()));
        xmlWriter.writeCloseTag();
    }

    private Iterator filterFactories(Iterator it) {
        ReportWriterContext writer = this.getReportWriter();
        ArrayList factories = new ArrayList();
        while (it.hasNext()) {
            Object o = it.next();
            if (o.equals(writer.getClassFactoryCollector()) || o.equals(writer.getDataSourceCollector()) || o.equals(writer.getElementFactoryCollector()) || o.equals(writer.getStyleKeyFactoryCollector()) || o.equals(writer.getTemplateCollector()) || factories.contains(o)) continue;
            factories.add(o);
        }
        return factories.iterator();
    }

    public void writeFactory(String tagName, Iterator it) throws IOException {
        while (it.hasNext()) {
            Object itObject = it.next();
            Class<?> itClass = itObject.getClass();
            if (!AbstractXMLDefinitionWriter.hasPublicDefaultConstructor(itClass)) {
                StringBuilder message = new StringBuilder(100);
                message.append("FactoryClass ");
                message.append(itObject.getClass());
                message.append(" has no default constructor. This class will be ignored");
                logger.warn((Object)message.toString());
                continue;
            }
            String className = itObject.getClass().getName();
            this.getXmlWriter().writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", tagName, "class", className, true);
        }
    }
}

