/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.IOException;
import java.util.Enumeration;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.DataFactoryWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ReportConfigWriter
extends AbstractXMLDefinitionWriter {
    protected static final String PAGE_DEFINITION_TAG = "page-definition";
    protected static final String SIMPLE_PAGE_DEFINITION_TAG = "simple-page-definition";
    protected static final String PAGE_TAG = "page";
    public static final String ORIENTATION_ATT = "orientation";
    public static final String ORIENTATION_PORTRAIT_VAL = "portrait";
    public static final String ORIENTATION_LANDSCAPE_VAL = "landscape";
    public static final String ORIENTATION_REVERSE_LANDSCAPE_VAL = "reverse_landscape";
    public static final String PAGEFORMAT_ATT = "pageformat";
    public static final String LEFTMARGIN_ATT = "leftmargin";
    public static final String RIGHTMARGIN_ATT = "rightmargin";
    public static final String TOPMARGIN_ATT = "topmargin";
    public static final String BOTTOMMARGIN_ATT = "bottommargin";
    private static final int TOP_BORDER = 0;
    private static final int LEFT_BORDER = 1;
    private static final int BOTTOM_BORDER = 2;
    private static final int RIGHT_BORDER = 3;

    public ReportConfigWriter(ReportWriterContext reportWriter, XmlWriter xmlWriter) {
        super(reportWriter, xmlWriter);
    }

    public void write() throws IOException, ReportWriterException {
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "report-config", false);
        AbstractReportDefinition report = this.getReport();
        if (report instanceof MasterReport) {
            MasterReport masterReport = (MasterReport)report;
            DataFactoryWriter writer = new DataFactoryWriter(this.getReportWriter(), this.getXmlWriter());
            writer.write();
            this.writePageDefinition();
            this.writeReportConfig(masterReport.getConfiguration());
        }
        xmlWriter.writeCloseTag();
    }

    private void writeReportConfig(Configuration config) throws IOException {
        XmlWriter writer = this.getXmlWriter();
        Enumeration properties = config.getConfigProperties();
        if (properties.hasMoreElements()) {
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "configuration", false);
            while (properties.hasMoreElements()) {
                String key = (String)properties.nextElement();
                String value = config.getConfigProperty(key);
                if (value == null) continue;
                writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "property", "name", key, false);
                writer.writeTextNormalized(value, false);
                writer.writeCloseTag();
            }
            writer.writeCloseTag();
        }
    }

    private void writePageDefinition() throws IOException {
        XmlWriter xmlWriter = this.getXmlWriter();
        PageDefinition pageDefinition = this.getReport().getPageDefinition();
        if (pageDefinition instanceof SimplePageDefinition) {
            SimplePageDefinition spdef = (SimplePageDefinition)pageDefinition;
            AttributeList attr = new AttributeList();
            attr.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "width", String.valueOf(spdef.getPageCountHorizontal()));
            attr.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "height", String.valueOf(spdef.getPageCountVertical()));
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", SIMPLE_PAGE_DEFINITION_TAG, attr, false);
            AttributeList attributes = this.buildPageFormatProperties(spdef.getPageFormat(0));
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", PAGE_TAG, attributes, true);
            xmlWriter.writeCloseTag();
        } else {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", PAGE_DEFINITION_TAG, false);
            int max = pageDefinition.getPageCount();
            for (int i = 0; i < max; ++i) {
                PageFormat fmt = pageDefinition.getPageFormat(i);
                AttributeList attributes = this.buildPageFormatProperties(fmt);
                xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", PAGE_TAG, attributes, true);
            }
            xmlWriter.writeCloseTag();
        }
    }

    private AttributeList buildPageFormatProperties(PageFormat fmt) {
        AttributeList retval = new AttributeList();
        int[] borders = this.getBorders(fmt.getPaper());
        if (fmt.getOrientation() == 0) {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", ORIENTATION_ATT, ORIENTATION_LANDSCAPE_VAL);
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", TOPMARGIN_ATT, String.valueOf(borders[3]));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", LEFTMARGIN_ATT, String.valueOf(borders[0]));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", BOTTOMMARGIN_ATT, String.valueOf(borders[1]));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", RIGHTMARGIN_ATT, String.valueOf(borders[2]));
        } else if (fmt.getOrientation() == 1) {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", ORIENTATION_ATT, ORIENTATION_PORTRAIT_VAL);
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", TOPMARGIN_ATT, String.valueOf(borders[0]));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", LEFTMARGIN_ATT, String.valueOf(borders[1]));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", BOTTOMMARGIN_ATT, String.valueOf(borders[2]));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", RIGHTMARGIN_ATT, String.valueOf(borders[3]));
        } else {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", ORIENTATION_ATT, ORIENTATION_REVERSE_LANDSCAPE_VAL);
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", TOPMARGIN_ATT, String.valueOf(borders[1]));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", LEFTMARGIN_ATT, String.valueOf(borders[2]));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", BOTTOMMARGIN_ATT, String.valueOf(borders[3]));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", RIGHTMARGIN_ATT, String.valueOf(borders[0]));
        }
        int w = (int)fmt.getPaper().getWidth();
        int h = (int)fmt.getPaper().getHeight();
        String pageDefinition = PageFormatFactory.getInstance().getPageFormatName(w, h);
        if (pageDefinition != null) {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", PAGEFORMAT_ATT, pageDefinition);
        } else {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "width", String.valueOf(w));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "height", String.valueOf(h));
        }
        return retval;
    }

    private int[] getBorders(Paper p) {
        int[] retval = new int[]{(int)p.getImageableY(), (int)p.getImageableX(), (int)(p.getHeight() - (p.getImageableY() + p.getImageableHeight())), (int)(p.getWidth() - (p.getImageableX() + p.getImageableWidth()))};
        return retval;
    }
}

