/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.elements.ElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.elements.ElementFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.StyleKeyFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.StyleKeyFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateCollection;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ReportWriter
extends ReportWriterContext {
    private DataSourceCollector dataSourceCollector;
    private ElementFactoryCollector elementFactoryCollector;
    private ClassFactoryCollector classFactoryCollector;
    private StyleKeyFactoryCollector styleKeyFactoryCollector;
    private TemplateCollector templateCollector;
    private String encoding;
    private Configuration configuration;

    public static Configuration createDefaultConfiguration(MasterReport report) {
        ResourceManager resourceManager;
        URL value;
        HierarchicalConfiguration repConf = new HierarchicalConfiguration((Configuration)report.getReportConfiguration());
        ResourceKey contentBase = report.getContentBase();
        if (contentBase != null && (value = (resourceManager = report.getResourceManager()).toURL(contentBase)) != null) {
            repConf.setConfigProperty("content-base", value.toExternalForm());
        }
        return repConf;
    }

    public ReportWriter(MasterReport reportDefinition, String encoding) {
        this(reportDefinition, encoding, ReportWriter.createDefaultConfiguration(reportDefinition));
    }

    public ReportWriter(MasterReport report, String encoding, Configuration config) {
        super(report);
        if (encoding == null) {
            throw new NullPointerException("Encoding is null.");
        }
        if (config == null) {
            throw new NullPointerException("Configuration is null.");
        }
        this.encoding = encoding;
        this.configuration = config;
        this.dataSourceCollector = new DataSourceCollector();
        this.elementFactoryCollector = new ElementFactoryCollector();
        this.classFactoryCollector = new ClassFactoryCollector();
        this.classFactoryCollector.addFactory(this.dataSourceCollector);
        this.styleKeyFactoryCollector = new StyleKeyFactoryCollector();
        this.templateCollector = new TemplateCollector();
        this.dataSourceCollector.configure(this.configuration);
        this.classFactoryCollector.configure(this.configuration);
        this.templateCollector.configure(this.configuration);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void addDataSourceFactory(DataSourceFactory dsf) {
        this.dataSourceCollector.addFactory(dsf);
    }

    public DataSourceCollector getDataSourceCollector() {
        return this.dataSourceCollector;
    }

    public void addElementFactory(ElementFactory ef) {
        this.elementFactoryCollector.addFactory(ef);
    }

    public ElementFactoryCollector getElementFactoryCollector() {
        return this.elementFactoryCollector;
    }

    public void addClassFactoryFactory(ClassFactory cf) {
        this.classFactoryCollector.addFactory(cf);
    }

    public ClassFactoryCollector getClassFactoryCollector() {
        return this.classFactoryCollector;
    }

    public void addStyleKeyFactory(StyleKeyFactory skf) {
        this.styleKeyFactoryCollector.addFactory(skf);
    }

    public StyleKeyFactoryCollector getStyleKeyFactoryCollector() {
        return this.styleKeyFactoryCollector;
    }

    public void addTemplateCollection(TemplateCollection collection) {
        this.templateCollector.addTemplateCollection(collection);
    }

    public TemplateCollector getTemplateCollector() {
        return this.templateCollector;
    }

    public void write(Writer w) throws IOException, ReportWriterException {
        XmlWriter xmlWriter = new XmlWriter(w, this.createTagDescription());
        xmlWriter.writeXmlDeclaration(this.getEncoding());
        ReportDefinitionWriter writer = new ReportDefinitionWriter(this, xmlWriter);
        writer.write();
    }

    private TagDescription createTagDescription() {
        DefaultTagDescription defaultTagDescription = new DefaultTagDescription();
        defaultTagDescription.configure(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.");
        return defaultTagDescription;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

