/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.IOException;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.StyleWriter;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class StylesWriter
extends AbstractXMLDefinitionWriter {
    private final ArrayList reportStyles = new ArrayList();

    public StylesWriter(ReportWriterContext reportWriter, XmlWriter xmlWriter) {
        super(reportWriter, xmlWriter);
    }

    public void write() throws IOException, ReportWriterException {
        ElementStyleSheet[] styles = this.collectStyles();
        if (styles.length == 0) {
            return;
        }
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "styles", false);
        for (int i = 0; i < styles.length; ++i) {
            ElementStyleSheet style = styles[i];
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "style", "name", style.getName(), false);
            StyleWriter stW = new StyleWriter(this.getReportWriter(), style, xmlWriter);
            stW.write();
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
    }

    private ElementStyleSheet[] collectStyles() {
        AbstractReportDefinition report = this.getReport();
        this.collectStylesFromBand(report.getReportHeader());
        this.collectStylesFromBand(report.getReportFooter());
        this.collectStylesFromBand(report.getPageHeader());
        this.collectStylesFromBand(report.getPageFooter());
        this.collectStylesFromBand(report.getItemBand());
        for (int i = 0; i < report.getGroupCount(); ++i) {
            Group g = report.getGroup(i);
            this.collectStylesFromBand(g.getHeader());
            this.collectStylesFromBand(g.getFooter());
        }
        return this.reportStyles.toArray(new ElementStyleSheet[this.reportStyles.size()]);
    }

    private void collectStylesFromBand(Band band) {
        this.collectStylesFromElement(band);
        Element[] elements = band.getElementArray();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] instanceof Band) {
                this.collectStylesFromBand((Band)elements[i]);
                continue;
            }
            this.collectStylesFromElement(elements[i]);
        }
    }

    private void collectStylesFromElement(Element element) {
        ElementStyleSheet elementSheet = element.getStyle();
        ElementStyleSheet[] parents = elementSheet.getParents();
        for (int i = 0; i < parents.length; ++i) {
            ElementStyleSheet es = parents[i];
            this.addCollectableStyleSheet(es);
        }
    }

    private void addCollectableStyleSheet(ElementStyleSheet es) {
        if (es.isGlobalDefault()) {
            return;
        }
        ElementStyleSheet[] parents = es.getParents();
        for (int i = 0; i < parents.length; ++i) {
            ElementStyleSheet parentsheet = parents[i];
            this.addCollectableStyleSheet(parentsheet);
        }
        if (!this.reportStyles.contains(es)) {
            this.reportStyles.add(es);
        }
    }
}

