/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.IOException;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ObjectWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class TemplateWriter
extends ObjectWriter {
    private TemplateDescription template;
    private TemplateDescription parent;

    public TemplateWriter(ReportWriterContext reportWriter, XmlWriter indentLevel, TemplateDescription template, TemplateDescription parent) {
        super(reportWriter, template, indentLevel);
        if (template == null) {
            throw new NullPointerException("Template is null.");
        }
        if (parent == null) {
            throw new NullPointerException("Parent is null.");
        }
        this.parent = parent;
        this.template = template;
    }

    public void write() throws IOException, ReportWriterException {
        AttributeList attList = new AttributeList();
        if (this.template.getName() != null && !this.template.getName().equals(this.parent.getName())) {
            attList.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "name", this.template.getName());
        }
        attList.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "references", this.parent.getName());
        boolean tagWritten = false;
        XmlWriter writer = this.getXmlWriter();
        Iterator it = this.template.getParameterNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!this.shouldWriteParameter(name)) continue;
            if (!tagWritten) {
                writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "template", attList, false);
                tagWritten = true;
            }
            this.writeParameter(name);
        }
        if (tagWritten) {
            writer.writeCloseTag();
        } else {
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "template", attList, true);
        }
    }

    private boolean shouldWriteParameter(String parameterName) {
        Object parameterObject = this.template.getParameter(parameterName);
        if (parameterObject == null) {
            return false;
        }
        Object parentObject = this.parent.getParameter(parameterName);
        return !ObjectUtilities.equal((Object)parameterObject, (Object)parentObject);
    }
}

