/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.inlinedata;

import java.io.IOException;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.DataFactoryWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class TableDataFactoryWriteHandler
implements DataFactoryWriteHandler {
    public void write(ReportWriterContext reportWriter, XmlWriter xmlWriter, DataFactory dataFactory) throws IOException, ReportWriterException {
        if (reportWriter == null) {
            throw new NullPointerException();
        }
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        if (xmlWriter == null) {
            throw new NullPointerException();
        }
        try {
            TableDataFactory tableDataFactory = (TableDataFactory)dataFactory;
            AttributeList rootAttrs = new AttributeList();
            if (!xmlWriter.isNamespaceDefined("http://reporting.pentaho.org/namespaces/datasources/inline/1.0")) {
                rootAttrs.addNamespaceDeclaration("data", "http://reporting.pentaho.org/namespaces/datasources/inline/1.0");
            }
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "inline-datasource", rootAttrs, false);
            String[] tables = tableDataFactory.getQueryNames();
            for (int i = 0; i < tables.length; ++i) {
                String tableName = tables[i];
                TableModel tableModel = tableDataFactory.queryData(tableName, null);
                xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "inline-table", "name", tableName, false);
                xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "definition", false);
                Class[] colTypes = new Class[tableModel.getColumnCount()];
                for (int col = 0; col < tableModel.getColumnCount(); ++col) {
                    AttributeList colAttrs = new AttributeList();
                    colAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "name", tableModel.getColumnName(col));
                    Class<?> columnClass = tableModel.getColumnClass(col);
                    if (columnClass == null) {
                        colAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "type", Object.class.getName());
                        colTypes[col] = Object.class;
                    } else {
                        colAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "type", columnClass.getName());
                        colTypes[col] = columnClass;
                    }
                    xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "data", colAttrs, true);
                }
                xmlWriter.writeCloseTag();
                for (int row = 0; row < tableModel.getRowCount(); ++row) {
                    xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "row", false);
                    for (int col = 0; col < tableModel.getColumnCount(); ++col) {
                        AttributeList colAttrs = new AttributeList();
                        Object value = tableModel.getValueAt(row, col);
                        if (value == null) {
                            colAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "null", "true");
                            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "data", colAttrs, true);
                            continue;
                        }
                        Class<?> valueClass = value.getClass();
                        if (!ObjectUtilities.equal((Object)colTypes[col], valueClass)) {
                            colAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "type", valueClass.getName());
                        }
                        try {
                            String s = ConverterRegistry.toAttributeValue(value);
                            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "column", colAttrs, false);
                            xmlWriter.writeTextNormalized(s, true);
                            xmlWriter.writeCloseTag();
                            continue;
                        }
                        catch (BeanException e) {
                            throw new ReportWriterException("Unable to convert value at (row:" + row + ";column:" + col + ") into a string." + value.getClass());
                        }
                    }
                    xmlWriter.writeCloseTag();
                }
                xmlWriter.writeCloseTag();
            }
            xmlWriter.writeCloseTag();
        }
        catch (ReportDataFactoryException rfe) {
            throw new ReportWriterException("Failed to write data-factory", (Exception)((Object)rfe));
        }
    }
}

