/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import java.awt.Stroke;
import org.pentaho.reporting.engine.classic.core.elementfactory.AbstractContentElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.AbstractElementReadHandler;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractShapeElementReadHandler
extends AbstractElementReadHandler {
    private static final String SCALE_ATT = "scale";
    private static final String KEEP_ASPECT_RATIO_ATT = "keepAspectRatio";
    private static final String FILL_ATT = "fill";
    private static final String DRAW_ATT = "draw";

    protected AbstractShapeElementReadHandler() {
    }

    protected void startParsing(PropertyAttributes atts) throws SAXException {
        super.startParsing(atts);
        this.handleScale(atts);
        this.handleKeepAspectRatio(atts);
        this.handleFill(atts);
        this.handleDraw(atts);
        this.handleStroke(atts);
    }

    private void handleStroke(PropertyAttributes atts) throws ParseException {
        Stroke stroke;
        String strokeStyle = atts.getValue(this.getUri(), "stroke-style");
        String weightAttr = atts.getValue(this.getUri(), "weight");
        float weight = 1.0f;
        if (weightAttr != null) {
            weight = ParserUtil.parseFloat((String)weightAttr, (String)"Weight is given, but no number.", (Locator)this.getLocator());
        }
        if ((stroke = ReportParserUtil.parseStroke(strokeStyle, weight)) != null) {
            AbstractContentElementFactory elementFactory = (AbstractContentElementFactory)this.getElementFactory();
            elementFactory.setStroke(stroke);
        }
    }

    protected void handleScale(PropertyAttributes atts) throws ParseException {
        String booleanValue = atts.getValue(this.getUri(), SCALE_ATT);
        AbstractContentElementFactory elementFactory = (AbstractContentElementFactory)this.getElementFactory();
        Boolean scale = ParserUtil.parseBoolean((String)booleanValue, (Locator)this.getLocator());
        if (scale != null) {
            elementFactory.setScale(scale);
        }
    }

    protected void handleKeepAspectRatio(PropertyAttributes atts) throws ParseException {
        String booleanValue = atts.getValue(this.getUri(), KEEP_ASPECT_RATIO_ATT);
        AbstractContentElementFactory elementFactory = (AbstractContentElementFactory)this.getElementFactory();
        Boolean keepAspectRatio = ParserUtil.parseBoolean((String)booleanValue, (Locator)this.getLocator());
        if (keepAspectRatio != null) {
            elementFactory.setKeepAspectRatio(keepAspectRatio);
        }
    }

    protected void handleFill(PropertyAttributes atts) throws ParseException {
        String booleanValue = atts.getValue(this.getUri(), FILL_ATT);
        AbstractContentElementFactory elementFactory = (AbstractContentElementFactory)this.getElementFactory();
        Boolean fill = ParserUtil.parseBoolean((String)booleanValue, (Locator)this.getLocator());
        if (fill != null) {
            elementFactory.setShouldFill(fill);
        }
    }

    protected void handleDraw(PropertyAttributes atts) throws ParseException {
        String booleanValue = atts.getValue(this.getUri(), DRAW_ATT);
        AbstractContentElementFactory elementFactory = (AbstractContentElementFactory)this.getElementFactory();
        Boolean draw = ParserUtil.parseBoolean((String)booleanValue, (Locator)this.getLocator());
        if (draw != null) {
            elementFactory.setShouldDraw(draw);
        }
    }
}

