/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupList;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.DataFactoryReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.DataFactoryReadHandlerFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ConfigurationReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.FunctionsReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.IncludeReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ParserConfigurationReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.GroupsReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.PageBandReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.ReportFooterReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.ReportHeaderReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.RootLevelBandReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.WatermarkReadHandler;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class JFreeReportReadHandler
extends AbstractPropertyXmlReadHandler {
    private static final Log logger = LogFactory.getLog(JFreeReportReadHandler.class);
    public static final String REPORT_TAG = "report";
    public static final String NAME_ATT = "name";
    public static final String PAGEFORMAT_ATT = "pageformat";
    public static final String PAGESPAN_ATT = "pagespan";
    public static final String UNIT_ATT = "unit";
    public static final String LEFTMARGIN_ATT = "leftmargin";
    public static final String RIGHTMARGIN_ATT = "rightmargin";
    public static final String TOPMARGIN_ATT = "topmargin";
    public static final String BOTTOMMARGIN_ATT = "bottommargin";
    public static final String WIDTH_ATT = "width";
    public static final String HEIGHT_ATT = "height";
    public static final String ORIENTATION_ATT = "orientation";
    public static final String ORIENTATION_PORTRAIT_VAL = "portrait";
    public static final String ORIENTATION_LANDSCAPE_VAL = "landscape";
    public static final String ORIENTATION_REVERSE_LANDSCAPE_VAL = "reverse_landscape";
    private MasterReport report;
    private DataFactoryReadHandler dataFactoryReadHandler;
    private GroupList groupList = new GroupList();

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) {
        super.init(rootHandler, uri, tagName);
        rootHandler.setHelperObject("property-expansion", (Object)Boolean.TRUE);
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        MasterReport report;
        Object maybeReport = this.getRootHandler().getHelperObject("::Report");
        if (!(maybeReport instanceof MasterReport)) {
            report = new MasterReport();
            report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", this.getRootHandler().getSource());
        } else {
            report = (MasterReport)maybeReport;
        }
        int groupCount = report.getGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            Group g = report.getGroup(i);
            if (!(g instanceof RelationalGroup)) {
                throw new ParseException("The existing report contains non-default groups. This parser cannot handle such a construct.");
            }
            this.groupList.add((RelationalGroup)g);
        }
        RootXmlReadHandler parser = this.getRootHandler();
        if (!ReportParserUtil.isIncluded(parser)) {
            String name;
            String query = attrs.getValue(this.getUri(), "query");
            if (query != null) {
                report.setQuery(query);
            }
            if ((name = attrs.getValue(this.getUri(), NAME_ATT)) != null) {
                report.setName(name);
            }
            PageFormat format = report.getPageDefinition().getPageFormat(0);
            float defTopMargin = (float)format.getImageableY();
            float defBottomMargin = (float)(format.getHeight() - format.getImageableHeight() - format.getImageableY());
            float defLeftMargin = (float)format.getImageableX();
            float defRightMargin = (float)(format.getWidth() - format.getImageableWidth() - format.getImageableX());
            format = this.createPageFormat(format, attrs);
            defTopMargin = ParserUtil.parseFloat((String)attrs.getValue(this.getUri(), TOPMARGIN_ATT), (float)defTopMargin);
            defBottomMargin = ParserUtil.parseFloat((String)attrs.getValue(this.getUri(), BOTTOMMARGIN_ATT), (float)defBottomMargin);
            defLeftMargin = ParserUtil.parseFloat((String)attrs.getValue(this.getUri(), LEFTMARGIN_ATT), (float)defLeftMargin);
            defRightMargin = ParserUtil.parseFloat((String)attrs.getValue(this.getUri(), RIGHTMARGIN_ATT), (float)defRightMargin);
            Paper p = format.getPaper();
            switch (format.getOrientation()) {
                case 1: {
                    PageFormatFactory.getInstance().setBorders(p, defTopMargin, defLeftMargin, defBottomMargin, defRightMargin);
                    break;
                }
                case 0: {
                    PageFormatFactory.getInstance().setBorders(p, defRightMargin, defTopMargin, defLeftMargin, defBottomMargin);
                    break;
                }
                case 2: {
                    PageFormatFactory.getInstance().setBorders(p, defLeftMargin, defBottomMargin, defRightMargin, defTopMargin);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected paper orientation.");
                }
            }
            int pageSpan = ParserUtil.parseInt((String)attrs.getValue(this.getUri(), PAGESPAN_ATT), (int)1);
            format.setPaper(p);
            report.setPageDefinition(new SimplePageDefinition(format, pageSpan, 1));
        }
        this.getRootHandler().setHelperObject("::Report", (Object)report);
        String useMinChunkWidth = attrs.getValue(this.getUri(), "use-min-chunkwidth");
        if (useMinChunkWidth != null) {
            report.getStyle().setStyleProperty(ElementStyleKeys.USE_MIN_CHUNKWIDTH, ReportParserUtil.parseBoolean(useMinChunkWidth, this.getLocator()));
        }
        this.report = report;
    }

    private PageFormat createPageFormat(PageFormat format, Attributes atts) throws SAXException {
        int orientationVal;
        String pageformatName = atts.getValue(this.getUri(), PAGEFORMAT_ATT);
        String orientation = atts.getValue(this.getUri(), ORIENTATION_ATT);
        if (orientation == null) {
            orientationVal = 1;
        } else if (orientation.equals(ORIENTATION_LANDSCAPE_VAL)) {
            orientationVal = 0;
        } else if (orientation.equals(ORIENTATION_REVERSE_LANDSCAPE_VAL)) {
            orientationVal = 2;
        } else if (orientation.equals(ORIENTATION_PORTRAIT_VAL)) {
            orientationVal = 1;
        } else {
            throw new ParseException("Orientation value in REPORT-Tag is invalid.", this.getRootHandler().getDocumentLocator());
        }
        if (pageformatName != null) {
            Paper p = PageFormatFactory.getInstance().createPaper(pageformatName);
            if (p == null) {
                logger.warn((Object)("Unable to create the requested Paper. " + pageformatName));
                return format;
            }
            return PageFormatFactory.getInstance().createPageFormat(p, orientationVal);
        }
        if (atts.getValue(this.getUri(), WIDTH_ATT) != null && atts.getValue(this.getUri(), HEIGHT_ATT) != null) {
            int[] pageformatData = new int[]{ParserUtil.parseInt((String)atts.getValue(this.getUri(), WIDTH_ATT), (String)"No Width set", (Locator)this.getLocator()), ParserUtil.parseInt((String)atts.getValue(this.getUri(), HEIGHT_ATT), (String)"No Height set", (Locator)this.getLocator())};
            Paper p = PageFormatFactory.getInstance().createPaper(pageformatData);
            if (p == null) {
                logger.warn((Object)("Unable to create the requested Paper. Paper={" + pageformatData[0] + ", " + pageformatData[1] + '}'));
                return format;
            }
            return PageFormatFactory.getInstance().createPageFormat(p, orientationVal);
        }
        logger.info((Object)"Insufficient Data to create a pageformat: Returned default.");
        return format;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        DataFactoryReadHandlerFactory factory = DataFactoryReadHandlerFactory.getInstance();
        DataFactoryReadHandler handler = (DataFactoryReadHandler)factory.getHandler(uri, tagName);
        if (handler != null) {
            this.dataFactoryReadHandler = handler;
            return handler;
        }
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("configuration".equals(tagName)) {
            return new ConfigurationReadHandler(this.report.getReportConfiguration());
        }
        if ("reportheader".equals(tagName)) {
            return new ReportHeaderReadHandler(this.report.getReportHeader());
        }
        if ("reportfooter".equals(tagName)) {
            return new ReportFooterReadHandler(this.report.getReportFooter());
        }
        if ("pageheader".equals(tagName)) {
            return new PageBandReadHandler(this.report.getPageHeader());
        }
        if ("pagefooter".equals(tagName)) {
            return new PageBandReadHandler(this.report.getPageFooter());
        }
        if ("watermark".equals(tagName)) {
            return new WatermarkReadHandler(this.report.getWatermark());
        }
        if ("no-data-band".equals(tagName)) {
            return new RootLevelBandReadHandler(this.report.getNoDataBand());
        }
        if ("groups".equals(tagName)) {
            return new GroupsReadHandler(this.groupList);
        }
        if ("items".equals(tagName)) {
            return new RootLevelBandReadHandler(this.report.getItemBand());
        }
        if ("functions".equals(tagName)) {
            return new FunctionsReadHandler(this.report);
        }
        if ("include".equals(tagName)) {
            return new IncludeReadHandler();
        }
        if ("parser-config".equals(tagName)) {
            return new ParserConfigurationReadHandler();
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        DataFactory dataFactory;
        if (this.dataFactoryReadHandler != null && (dataFactory = this.dataFactoryReadHandler.getDataFactory()) != null) {
            this.report.setDataFactory(dataFactory);
        }
        try {
            GroupList groupList1 = (GroupList)this.groupList.clone();
            this.report.setGroups(groupList1);
        }
        catch (CloneNotSupportedException e) {
            throw new ParseException("Failed to add group-list to report", this.getLocator());
        }
        this.report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "file-format", "simple-xml");
    }

    public Object getObject() {
        return this.report;
    }
}

