/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.RootLevelBandReadHandler;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class PageBandReadHandler
extends RootLevelBandReadHandler {
    public static final String ON_FIRST_PAGE_ATTR = "onfirstpage";
    public static final String ON_LAST_PAGE_ATTR = "onlastpage";

    public PageBandReadHandler(Band band) {
        super(band);
    }

    protected void startParsing(PropertyAttributes attr) throws SAXException {
        super.startParsing(attr);
        this.handleOnFirstPage(attr);
        this.handleOnLastPage(attr);
        this.handleSticky(attr);
    }

    private void handleSticky(PropertyAttributes attr) throws SAXException {
        String repeat = attr.getValue(this.getUri(), "sticky");
        Boolean repeatVal = ParserUtil.parseBoolean((String)repeat, (Locator)this.getLocator());
        this.getBand().getStyle().setStyleProperty(BandStyleKeys.STICKY, repeatVal);
    }

    protected boolean isManualBreakAllowed() {
        return false;
    }

    private void handleOnFirstPage(PropertyAttributes attr) throws SAXException {
        String breakBeforeAttr = attr.getValue(this.getUri(), ON_FIRST_PAGE_ATTR);
        Boolean breakBefore = ParserUtil.parseBoolean((String)breakBeforeAttr, (Locator)this.getLocator());
        this.getBand().getStyle().setStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, breakBefore);
    }

    private void handleOnLastPage(PropertyAttributes attr) throws SAXException {
        String breakBeforeAttr = attr.getValue(this.getUri(), ON_LAST_PAGE_ATTR);
        Boolean breakBefore = ParserUtil.parseBoolean((String)breakBeforeAttr, (Locator)this.getLocator());
        this.getBand().getStyle().setStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE, breakBefore);
    }
}

