/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.IncludeSubReportReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.BandReadHandler;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RootLevelBandReadHandler
extends BandReadHandler {
    public static final String FIXED_POSITION_ATTRIBUTE = "fixed-position";
    public static final String PAGEBREAK_BEFORE_ATTR = "pagebreak-before-print";
    public static final String HEIGHT_ATTRIBUTE = "height";
    public static final String PAGEBREAK_AFTER_ATTRIBUTE = "pagebreak-after-print";
    public static final String ALIGNMENT_ATT = "alignment";
    public static final String VALIGNMENT_ATT = "vertical-alignment";
    private ArrayList subReportHandlers = new ArrayList();

    public RootLevelBandReadHandler(Band band) {
        super(band);
    }

    protected void startParsing(PropertyAttributes attr) throws SAXException {
        super.startParsing(attr);
        this.handleHeight(attr);
        this.handleFixedPosition(attr);
        if (this.isManualBreakAllowed()) {
            this.handleBreakAfter(attr);
            this.handleBreakBefore(attr);
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (this.isSameNamespace(uri) && "sub-report".equals(tagName)) {
            IncludeSubReportReadHandler subReportReadHandler = new IncludeSubReportReadHandler();
            this.subReportHandlers.add(subReportReadHandler);
            return subReportReadHandler;
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    protected boolean isManualBreakAllowed() {
        return true;
    }

    private void handleFixedPosition(PropertyAttributes attr) throws SAXException {
        String fixedPos = attr.getValue(this.getUri(), FIXED_POSITION_ATTRIBUTE);
        if (fixedPos != null) {
            float fixedPosValue = ParserUtil.parseFloat((String)fixedPos, (String)"FixedPosition is invalid!", (Locator)this.getLocator());
            this.getBand().getStyle().setStyleProperty(BandStyleKeys.FIXED_POSITION, new Float(fixedPosValue));
        }
    }

    private void handleHeight(PropertyAttributes attr) throws ParseException {
        String height = attr.getValue(this.getUri(), HEIGHT_ATTRIBUTE);
        if (height != null) {
            float heightValue = ParserUtil.parseFloat((String)height, (String)"Height is invalid.", (Locator)this.getLocator());
            this.getBand().getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, new Float(heightValue));
        }
    }

    private void handleBreakBefore(PropertyAttributes attr) throws SAXException {
        String breakBeforeAttr = attr.getValue(this.getUri(), PAGEBREAK_BEFORE_ATTR);
        Boolean breakBefore = ParserUtil.parseBoolean((String)breakBeforeAttr, (Locator)this.getLocator());
        this.getBand().getStyle().setStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE, breakBefore);
    }

    private void handleBreakAfter(PropertyAttributes attr) throws SAXException {
        String breakAfterAttr = attr.getValue(this.getUri(), PAGEBREAK_AFTER_ATTRIBUTE);
        if (breakAfterAttr != null) {
            Boolean breakAfter = ParserUtil.parseBoolean((String)breakAfterAttr, (Locator)this.getLocator());
            this.getBand().getStyle().setStyleProperty(BandStyleKeys.PAGEBREAK_AFTER, breakAfter);
        }
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        Band band = this.getBand();
        if (band instanceof AbstractRootLevelBand) {
            AbstractRootLevelBand arlb = (AbstractRootLevelBand)band;
            for (int i = 0; i < this.subReportHandlers.size(); ++i) {
                IncludeSubReportReadHandler handler = (IncludeSubReportReadHandler)((Object)this.subReportHandlers.get(i));
                arlb.addSubReport((SubReport)handler.getObject());
            }
        }
    }
}

