/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import java.util.HashMap;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterValues;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ComputedParameterValues
extends DefaultParameterValues {
    private FormulaExpression formula;
    private ComputedParameterExpressionRuntime expressionRuntime;

    public ComputedParameterValues(TableModel parent, String keyColumn, String valueColumn, String valueFormula, ParameterContext context) throws ReportProcessingException {
        super(parent, keyColumn, valueColumn);
        if (valueFormula == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        this.expressionRuntime = new ComputedParameterExpressionRuntime(context, new TableDataRow(parent, valueColumn));
        FormulaExpression expression = new FormulaExpression();
        expression.setFormula(valueFormula);
        this.formula = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTextValue(int row) {
        this.expressionRuntime.setCurrentRow(row);
        this.expressionRuntime.setValue(super.getTextValue(row));
        this.formula.setRuntime(this.expressionRuntime);
        try {
            Object object = this.formula.getValue();
            return object;
        }
        finally {
            this.formula.setRuntime(null);
        }
    }

    private static class ComputedParameterExpressionRuntime
    extends ParameterExpressionRuntime {
        private TableDataRow dataRow;

        private ComputedParameterExpressionRuntime(ParameterContext parameterContext, TableDataRow dataRow) throws ReportProcessingException {
            super(parameterContext, dataRow);
            this.dataRow = dataRow;
        }

        public Configuration getConfiguration() {
            return this.getProcessingContext().getConfiguration();
        }

        public ResourceBundleFactory getResourceBundleFactory() {
            return this.getProcessingContext().getResourceBundleFactory();
        }

        public TableModel getData() {
            return this.dataRow.getData();
        }

        public int getCurrentRow() {
            return this.dataRow.getCurrentRow();
        }

        public void setCurrentRow(int currentRow) {
            this.dataRow.setCurrentRow(currentRow);
        }

        public Object getValue() {
            return this.dataRow.getValue();
        }

        public void setValue(Object value) {
            this.dataRow.setValue(value);
        }
    }

    private static class TableDataRow
    implements DataRow {
        private TableModel data;
        private int currentRow;
        private String[] columnNames;
        private HashMap nameindex;
        private String valueColumn;
        private Object value;

        private TableDataRow(TableModel data, String valueColumn) {
            if (data == null) {
                throw new NullPointerException();
            }
            this.data = data;
            this.columnNames = new String[data.getColumnCount()];
            this.nameindex = new HashMap();
            this.valueColumn = valueColumn;
            for (int i = 0; i < this.columnNames.length; ++i) {
                String name;
                this.columnNames[i] = name = data.getColumnName(i);
                this.nameindex.put(name, IntegerCache.getInteger(i));
            }
            this.currentRow = -1;
        }

        public int getCurrentRow() {
            return this.currentRow;
        }

        public void setCurrentRow(int currentRow) {
            if (currentRow < -1 || currentRow >= this.data.getRowCount()) {
                throw new IndexOutOfBoundsException();
            }
            this.currentRow = currentRow;
        }

        public Object get(String col) {
            if (col == null) {
                throw new NullPointerException();
            }
            if (this.currentRow >= 0) {
                Integer o = (Integer)this.nameindex.get(col);
                if (o == null) {
                    if (ObjectUtilities.equal((Object)col, (Object)this.valueColumn)) {
                        return this.getValue();
                    }
                    return null;
                }
                return this.data.getValueAt(this.currentRow, o);
            }
            return null;
        }

        public String[] getColumnNames() {
            if (StringUtils.isEmpty((String)this.valueColumn)) {
                return (String[])this.columnNames.clone();
            }
            String[] columnNames = new String[this.columnNames.length + 1];
            System.arraycopy(this.columnNames, 0, columnNames, 0, this.columnNames.length);
            columnNames[this.columnNames.length] = this.valueColumn;
            return columnNames;
        }

        public boolean isChanged(String name) {
            return false;
        }

        public TableModel getData() {
            return this.data;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

