/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultParameterContext
implements ParameterContext {
    private ReportEnvironment reportEnvironment;
    private CompoundDataRow parameterValues;
    private ResourceBundleFactory resourceBundleFactory;
    private Configuration configuration;
    private CachingDataFactory dataFactory;
    private ResourceKey contentBase;
    private ResourceManager resourceManager;
    private DocumentMetaData documentMetaData;
    private ReportEnvironmentDataRow envDataRow;

    public DefaultParameterContext(MasterReport report) throws ReportProcessingException {
        this(report, report.getParameterValues());
    }

    public DefaultParameterContext(MasterReport report, ReportParameterValues parameterValues) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException("Report parameter must not be null");
        }
        if (parameterValues == null) {
            throw new NullPointerException("ParameterValues parameter must not be null");
        }
        this.configuration = report.getConfiguration();
        this.resourceBundleFactory = MasterReport.computeAndInitResourceBundleFactory(report.getResourceBundleFactory(), report.getReportEnvironment());
        this.contentBase = report.getContentBase();
        this.resourceManager = report.getResourceManager();
        this.reportEnvironment = report.getReportEnvironment();
        Object dataCacheEnabledRaw = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "data-cache");
        boolean dataCacheEnabled = !Boolean.FALSE.equals(dataCacheEnabledRaw);
        this.dataFactory = new CachingDataFactory(report.getDataFactory(), dataCacheEnabled);
        DocumentBundle bundle = report.getBundle();
        if (bundle != null) {
            this.documentMetaData = bundle.getMetaData();
        }
        this.dataFactory.initialize(this.configuration, this.resourceManager, this.contentBase, this.resourceBundleFactory);
        ReportEnvironmentDataRow envDataRow = new ReportEnvironmentDataRow(this.reportEnvironment);
        this.parameterValues = new CompoundDataRow(envDataRow, parameterValues);
    }

    public DefaultParameterContext(DataFactory dataFactory, DataRow parameterValues, Configuration configuration, ResourceBundleFactory resourceBundleFactory, ResourceManager resourceManager, ResourceKey resourceKey, ReportEnvironment reportEnvironment) throws ReportDataFactoryException {
        this.configuration = configuration;
        this.resourceBundleFactory = resourceBundleFactory;
        this.resourceManager = resourceManager;
        this.contentBase = resourceKey;
        this.reportEnvironment = reportEnvironment;
        this.dataFactory = new CachingDataFactory(dataFactory, false);
        this.dataFactory.initialize(configuration, resourceManager, resourceKey, resourceBundleFactory);
        this.envDataRow = new ReportEnvironmentDataRow(reportEnvironment);
        this.parameterValues = new CompoundDataRow(this.envDataRow, parameterValues);
    }

    public DocumentMetaData getDocumentMetaData() {
        return this.documentMetaData;
    }

    public ReportEnvironment getReportEnvironment() {
        return this.reportEnvironment;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void open() throws ReportDataFactoryException {
        this.dataFactory.open();
    }

    public DataRow getParameterData() {
        return this.parameterValues;
    }

    public DataRow getParameterValues() {
        return this.parameterValues.getDataRow();
    }

    public void setParameterValues(DataRow parameterValues) {
        if (parameterValues == null) {
            throw new NullPointerException();
        }
        this.parameterValues = new CompoundDataRow(this.envDataRow, parameterValues);
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public void close() throws ReportDataFactoryException {
        this.dataFactory.close();
    }

    public ResourceKey getContentBase() {
        return this.contentBase;
    }
}

