/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ModifiableReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;

public class DefaultParameterDefinition
implements ModifiableReportParameterDefinition {
    private ArrayList parameters = new ArrayList();
    private ReportParameterValidator validator = new DefaultReportParameterValidator();
    private ReportAttributeMap attributeMap = new ReportAttributeMap();

    public void addParameterDefinition(ParameterDefinitionEntry entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        this.parameters.add(entry);
    }

    public void addParameterDefinition(int index, ParameterDefinitionEntry entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        this.parameters.add(index, entry);
    }

    public void removeParameterDefinition(int index) {
        this.parameters.remove(index);
    }

    public void setAttribute(String domain, String name, String value) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.attributeMap.setAttribute(domain, name, value);
    }

    public String getAttribute(String domain, String name) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        return (String)this.attributeMap.getAttribute(domain, name);
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public ParameterDefinitionEntry[] getParameterDefinitions() {
        return this.parameters.toArray(new ParameterDefinitionEntry[this.parameters.size()]);
    }

    public ParameterDefinitionEntry getParameterDefinition(int parameter) {
        return (ParameterDefinitionEntry)this.parameters.get(parameter);
    }

    public void setValidator(ReportParameterValidator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        this.validator = validator;
    }

    public ReportParameterValidator getValidator() {
        return this.validator;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultParameterDefinition def = (DefaultParameterDefinition)super.clone();
        def.parameters = (ArrayList)this.parameters.clone();
        def.attributeMap = (ReportAttributeMap)((Object)this.attributeMap.clone());
        return def;
    }

    public void removeParameterDefinition(ParameterDefinitionEntry definitionEntry) {
        this.parameters.remove(definitionEntry);
    }
}

