/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.parameters.Messages;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationMessage;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.ErrorValue;

public class FormulaParameterEvaluator {
    private static final Log logger = LogFactory.getLog(FormulaParameterEvaluator.class);

    private FormulaParameterEvaluator() {
    }

    public static ReportParameterValues evaluate(ValidationResult result, ReportParameterDefinition parameterDefinition, ParameterContext parameterContext) {
        ReportParameterValues parameterValues = new ReportParameterValues();
        parameterValues.putAll(parameterContext.getParameterData());
        ParameterDefinitionEntry[] entries = parameterDefinition.getParameterDefinitions();
        for (int i = 0; i < entries.length; ++i) {
            ParameterDefinitionEntry entry = entries[i];
            try {
                Object o = FormulaParameterEvaluator.computePostProcessingValue(result, parameterContext, parameterValues, entry, parameterValues.get(entry.getName()), entry.getDefaultValue(parameterContext));
                parameterValues.put(entry.getName(), o);
                continue;
            }
            catch (ReportProcessingException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unable to compute default value for parameter '" + entry.getName() + "'"), (Throwable)((Object)e));
                }
                if (result == null) continue;
                result.addError(entry.getName(), new ValidationMessage(Messages.getInstance().formatMessage("FormulaParameterEvaluator.PostProcessingInitFailed", e.getLocalizedMessage())));
            }
        }
        return parameterValues;
    }

    public static Object computePostProcessingValue(ValidationResult result, ParameterContext parameterContext, ReportParameterValues parameterValues, ParameterDefinitionEntry entry, Object untrustedValue, Object defaultValue) throws ReportProcessingException {
        ReportEnvironmentDataRow envDataRow = new ReportEnvironmentDataRow(parameterContext.getReportEnvironment());
        String formula = entry.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "post-processor-formula", parameterContext);
        if (StringUtils.isEmpty((String)formula, (boolean)true)) {
            return untrustedValue;
        }
        ParameterExpressionRuntime runtime = new ParameterExpressionRuntime(parameterContext, new CompoundDataRow(envDataRow, parameterValues));
        return FormulaParameterEvaluator.computeValue(runtime, formula, result, entry, defaultValue);
    }

    public static Object computeValue(ExpressionRuntime runtime, String formula, ValidationResult result, ParameterDefinitionEntry entry, Object defaultValue) {
        FormulaExpression fe = new FormulaExpression();
        fe.setFormula(formula);
        fe.setRuntime(runtime);
        Object value = fe.getValue();
        if (value == null) {
            Exception error = fe.getFormulaError();
            if (error != null) {
                if (result != null) {
                    result.addError(entry.getName(), new ValidationMessage(Messages.getInstance().formatMessage("FormulaParameterEvaluator.PostProcessingFormulaFailed", error.getLocalizedMessage())));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unable to compute default value for parameter '" + entry.getName() + "'"), (Throwable)error);
                }
                return null;
            }
            return defaultValue;
        }
        if (entry.getValueType().isInstance(value)) {
            return value;
        }
        if (value instanceof ErrorValue) {
            ErrorValue errorValue = (ErrorValue)value;
            if (result != null) {
                result.addError(entry.getName(), new ValidationMessage(Messages.getInstance().formatMessage("FormulaParameterEvaluator.PostProcessingFormulaFailed", errorValue.getErrorMessage(Locale.getDefault()))));
            }
            return null;
        }
        ValueConverter valueConverter = ConverterRegistry.getInstance().getValueConverter(entry.getValueType());
        if (valueConverter != null) {
            String textValue;
            try {
                textValue = ConverterRegistry.toAttributeValue(value);
            }
            catch (BeanException be) {
                textValue = String.valueOf(value);
            }
            try {
                return ConverterRegistry.toPropertyValue(textValue, entry.getValueType());
            }
            catch (BeanException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unable to convert computed default value for parameter '" + entry.getName() + "'"), (Throwable)((Object)e));
                }
                if (result != null) {
                    result.addError(entry.getName(), new ValidationMessage(Messages.getInstance().getString("FormulaParameterEvaluator.ErrorConvertingValue")));
                    result.addError(entry.getName(), new ValidationMessage("The post-processing result cannot be converted into the target-type."));
                }
                return null;
            }
        }
        return defaultValue;
    }
}

