/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.parameters.AbstractParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterValues;

public class StaticListParameter
extends AbstractParameter
implements ListParameter {
    private boolean strictValueCheck;
    private boolean allowMultiSelection;
    private StaticParameterValues parameterValues;

    public StaticListParameter(String name, boolean allowMultiSelection, boolean strictValueCheck, Class valueType) {
        super(name, valueType);
        this.allowMultiSelection = allowMultiSelection;
        this.strictValueCheck = strictValueCheck;
        this.parameterValues = new StaticParameterValues();
    }

    public void addValues(Object key, Object value) {
        this.parameterValues.add(key, value);
    }

    public boolean isAllowMultiSelection() {
        return this.allowMultiSelection;
    }

    public boolean isStrictValueCheck() {
        return this.strictValueCheck;
    }

    public ParameterValues getValues(ParameterContext context) throws ReportDataFactoryException {
        if (context == null) {
            throw new NullPointerException();
        }
        return this.parameterValues;
    }

    private boolean isParameterAutoSelectFirstValue(ParameterContext parameterContext) {
        return "true".equals(parameterContext.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.ParameterAutoFillsSelection"));
    }

    public Object getDefaultValue(ParameterContext context) throws ReportDataFactoryException {
        ParameterValues values;
        Object o = super.getDefaultValue(context);
        if (o != null) {
            return o;
        }
        if (this.isParameterAutoSelectFirstValue(context) && (values = this.getValues(context)).getRowCount() > 0) {
            if (this.allowMultiSelection) {
                Class valueType1 = this.getValueType();
                Object array = valueType1.isArray() ? Array.newInstance(valueType1.getComponentType(), 1) : Array.newInstance(valueType1, 1);
                Array.set(array, 0, values.getKeyValue(0));
            } else {
                values.getKeyValue(0);
            }
        }
        if (this.allowMultiSelection) {
            Class valueType1 = this.getValueType();
            if (valueType1.isArray()) {
                return Array.newInstance(valueType1.getComponentType(), 0);
            }
            return Array.newInstance(valueType1, 0);
        }
        return null;
    }

    private static class StaticParameterValues
    implements ParameterValues {
        private ArrayList<Object[]> backend = new ArrayList();

        public void add(Object key, Object value) {
            this.backend.add(new Object[]{key, value});
        }

        public int getRowCount() {
            return this.backend.size();
        }

        public Object getKeyValue(int row) {
            Object[] o = this.backend.get(row);
            return o[0];
        }

        public Object getTextValue(int row) {
            Object[] o = this.backend.get(row);
            return o[1];
        }
    }
}

