/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import org.pentaho.reporting.engine.classic.core.states.GroupStartRecord;
import org.pentaho.reporting.engine.classic.core.states.GroupingState;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DefaultGroupingState
implements GroupingState {
    public static final GroupingState EMPTY = new DefaultGroupingState();
    private int currentGroup;
    private FastStack groupStarts;

    protected DefaultGroupingState() {
        this.currentGroup = -1;
        this.groupStarts = new FastStack();
    }

    public DefaultGroupingState(int currentGroup, FastStack groupStarts) {
        this.currentGroup = currentGroup;
        this.groupStarts = groupStarts;
    }

    public int getCurrentGroup() {
        return this.currentGroup;
    }

    public int getGroupStartRow(String group) {
        int size = this.groupStarts.size();
        for (int i = 0; i < size; ++i) {
            GroupStartRecord o = (GroupStartRecord)this.groupStarts.get(i);
            if (!ObjectUtilities.equal((Object)o.getGroupName(), (Object)group)) continue;
            return o.getRow();
        }
        return 0;
    }

    public int getGroupStartRow(int group) {
        if (group < 0 || group >= this.groupStarts.size()) {
            if (this.groupStarts.isEmpty()) {
                return 0;
            }
            GroupStartRecord o = (GroupStartRecord)this.groupStarts.peek();
            return o.getRow();
        }
        GroupStartRecord o = (GroupStartRecord)this.groupStarts.get(group);
        return o.getRow();
    }
}

