/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;

public class IndexedTableModel
implements CloseableTableModel,
MetaTableModel {
    private CloseableTableModel closeableTableModel;
    private TableModel backend;

    public IndexedTableModel(TableModel backend) {
        if (backend == null) {
            throw new NullPointerException();
        }
        if (backend instanceof CloseableTableModel) {
            this.closeableTableModel = (CloseableTableModel)backend;
        }
        this.backend = backend;
    }

    public void close() {
        if (this.closeableTableModel != null) {
            this.closeableTableModel.close();
        }
    }

    public int getRowCount() {
        return this.backend.getRowCount();
    }

    public int getColumnCount() {
        return 2 * this.backend.getColumnCount();
    }

    protected int indexToColumn(int col) {
        if (col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = this.backend.getColumnCount();
        if (col >= count * 2) {
            throw new IndexOutOfBoundsException();
        }
        if (col < count) {
            return col;
        }
        return col - count;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (columnIndex < this.backend.getColumnCount()) {
            return this.backend.getColumnName(columnIndex);
        }
        return "::column::" + this.indexToColumn(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.backend.getColumnClass(this.indexToColumn(columnIndex));
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.backend.isCellEditable(rowIndex, this.indexToColumn(columnIndex));
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.backend.getValueAt(rowIndex, this.indexToColumn(columnIndex));
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.backend.setValueAt(aValue, rowIndex, this.indexToColumn(columnIndex));
    }

    public void addTableModelListener(TableModelListener l) {
        this.backend.addTableModelListener(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.backend.removeTableModelListener(l);
    }

    public DataAttributes getCellDataAttributes(int row, int column) {
        return EmptyDataAttributes.INSTANCE;
    }

    public boolean isCellDataAttributesSupported() {
        return false;
    }

    public DataAttributes getColumnAttributes(int column) {
        if (column < this.backend.getColumnCount()) {
            return new ColumnIndexDataAttributes(null, Boolean.FALSE);
        }
        return new ColumnIndexDataAttributes(null, Boolean.TRUE);
    }

    public DataAttributes getTableAttributes() {
        return EmptyDataAttributes.INSTANCE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IndexedTableModel");
        sb.append("={backend=").append(this.backend);
        sb.append('}');
        return sb.toString();
    }

    protected static class ColumnIndexDataAttributes
    implements DataAttributes {
        private DataAttributes backend;
        private Boolean indexColumn;

        public ColumnIndexDataAttributes(DataAttributes backend, Boolean indexColumn) {
            this.backend = backend;
            this.indexColumn = indexColumn;
            if (backend == null) {
                this.backend = EmptyDataAttributes.INSTANCE;
            }
        }

        private boolean contains(String[] hay, String needle) {
            for (int i = 0; i < hay.length; ++i) {
                if (!needle.equals(hay[i])) continue;
                return true;
            }
            return false;
        }

        public String[] getMetaAttributeDomains() {
            String[] domains = this.backend.getMetaAttributeDomains();
            if (this.contains(domains, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/core")) {
                return domains;
            }
            String[] strings = new String[domains.length + 1];
            System.arraycopy(domains, 0, strings, 0, domains.length);
            strings[domains.length] = "http://reporting.pentaho.org/namespaces/engine/meta-attributes/core";
            return strings;
        }

        public String[] getMetaAttributeNames(String domainName) {
            if (!"http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domainName)) {
                return this.backend.getMetaAttributeNames(domainName);
            }
            String[] attributeNames = this.backend.getMetaAttributeNames(domainName);
            if (this.contains(attributeNames, "indexed-column")) {
                return attributeNames;
            }
            String[] strings = new String[attributeNames.length + 1];
            System.arraycopy(attributeNames, 0, strings, 0, attributeNames.length);
            strings[attributeNames.length] = "indexed-column";
            return strings;
        }

        public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
            return this.getMetaAttribute(domain, name, type, context, null);
        }

        public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
            Object retval = this.backend.getMetaAttribute(domain, name, type, context, defaultValue);
            if (retval != null) {
                return retval;
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domain) && "indexed-column".equals(name)) {
                return this.indexColumn;
            }
            return defaultValue;
        }

        public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
            ConceptQueryMapper retval = this.backend.getMetaAttributeMapper(domain, name);
            if (retval != null) {
                return retval;
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domain) && "indexed-column".equals(name)) {
                return DefaultConceptQueryMapper.INSTANCE;
            }
            return null;
        }

        public Object clone() throws CloneNotSupportedException {
            ColumnIndexDataAttributes dataAttributes = (ColumnIndexDataAttributes)super.clone();
            dataAttributes.backend = (DataAttributes)this.backend.clone();
            return dataAttributes;
        }
    }
}

