/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.states.LayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.datarow.InlineDataRowRuntime;

public class InitialLayoutProcess
implements LayoutProcess {
    private static final StructureFunction[] EMPTY_FUNCTIONS = new StructureFunction[0];
    private InlineDataRowRuntime inlineDataRowRuntime;
    private OutputFunction outputFunction;
    private boolean outputFunctionIsPageListener;

    public InitialLayoutProcess(OutputFunction outputFunction) {
        if (outputFunction == null) {
            throw new NullPointerException();
        }
        this.outputFunction = outputFunction;
        this.outputFunctionIsPageListener = outputFunction instanceof PageEventListener;
    }

    public LayoutProcess getParent() {
        return null;
    }

    public boolean isPageListener() {
        return this.outputFunctionIsPageListener;
    }

    public OutputFunction getOutputFunction() {
        return this.outputFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(ReportState state) throws ReportProcessingException {
        ExpressionRuntime oldRuntime;
        if (this.inlineDataRowRuntime == null) {
            this.inlineDataRowRuntime = new InlineDataRowRuntime();
        }
        this.inlineDataRowRuntime.setState(state);
        OutputFunction outputFunction = this.getOutputFunction();
        if (outputFunction != null) {
            oldRuntime = outputFunction.getRuntime();
            outputFunction.setRuntime(this.inlineDataRowRuntime);
        } else {
            oldRuntime = null;
        }
        try {
            if (outputFunction != null) {
                outputFunction.restart(state);
            }
        }
        finally {
            if (outputFunction != null) {
                outputFunction.setRuntime(oldRuntime);
            }
        }
    }

    public StructureFunction[] getCollectionFunctions() {
        return EMPTY_FUNCTIONS;
    }

    public LayoutProcess deriveForStorage() {
        try {
            InitialLayoutProcess lp = (InitialLayoutProcess)super.clone();
            lp.inlineDataRowRuntime = null;
            lp.outputFunction = this.outputFunction.deriveForStorage();
            return lp;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public LayoutProcess deriveForPagebreak() {
        try {
            InitialLayoutProcess lp = (InitialLayoutProcess)super.clone();
            lp.inlineDataRowRuntime = null;
            lp.outputFunction = this.outputFunction.deriveForPagebreak();
            return lp;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        InitialLayoutProcess lp = (InitialLayoutProcess)super.clone();
        lp.inlineDataRowRuntime = null;
        lp.outputFunction = (OutputFunction)this.outputFunction.clone();
        return lp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireReportEvent(ReportEvent event) {
        block18: {
            ExpressionRuntime oldRuntime;
            int type = event.getType();
            if (this.inlineDataRowRuntime == null) {
                this.inlineDataRowRuntime = new InlineDataRowRuntime();
            }
            this.inlineDataRowRuntime.setState(event.getState());
            OutputFunction outputFunction = this.getOutputFunction();
            if (outputFunction != null) {
                oldRuntime = outputFunction.getRuntime();
                outputFunction.setRuntime(this.inlineDataRowRuntime);
            } else {
                oldRuntime = null;
            }
            try {
                if ((type & 2) == 2) {
                    this.firePageStartedEvent(event);
                    break block18;
                }
                if ((type & 0x400) == 1024) {
                    this.firePageFinishedEvent(event);
                    break block18;
                }
                if ((type & 0x20) == 32) {
                    this.fireItemsAdvancedEvent(event);
                    break block18;
                }
                if ((type & 0x40) == 64) {
                    this.fireItemsFinishedEvent(event);
                    break block18;
                }
                if ((type & 0x10) == 16) {
                    this.fireItemsStartedEvent(event);
                    break block18;
                }
                if ((type & 0x80) == 128) {
                    this.fireGroupFinishedEvent(event);
                    break block18;
                }
                if ((type & 8) == 8) {
                    this.fireGroupStartedEvent(event);
                    break block18;
                }
                if ((type & 1) == 1) {
                    this.fireReportInitializedEvent(event);
                    break block18;
                }
                if ((type & 0x200) == 512) {
                    this.fireReportDoneEvent(event);
                    break block18;
                }
                if ((type & 0x100) == 256) {
                    this.fireReportFinishedEvent(event);
                    break block18;
                }
                if ((type & 4) == 4) {
                    this.fireReportStartedEvent(event);
                    break block18;
                }
                throw new IllegalArgumentException();
            }
            finally {
                if (outputFunction != null) {
                    outputFunction.setRuntime(oldRuntime);
                }
            }
        }
    }

    private void fireItemsAdvancedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2) {
            this.outputFunction.itemsAdvanced(event);
        }
    }

    private void fireItemsStartedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2) {
            this.outputFunction.itemsStarted(event);
        }
    }

    private void fireItemsFinishedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2) {
            this.outputFunction.itemsFinished(event);
        }
    }

    private void fireGroupStartedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2) {
            this.outputFunction.groupStarted(event);
        }
    }

    private void fireGroupFinishedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2) {
            this.outputFunction.groupFinished(event);
        }
    }

    private void fireReportStartedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2) {
            this.outputFunction.reportStarted(event);
        }
    }

    private void fireReportDoneEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2) {
            this.outputFunction.reportDone(event);
        }
    }

    private void fireReportFinishedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2) {
            this.outputFunction.reportFinished(event);
        }
    }

    private void fireReportInitializedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2) {
            this.outputFunction.reportInitialized(event);
        }
    }

    private void firePageStartedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2 && this.outputFunctionIsPageListener) {
            PageEventListener pel = (PageEventListener)((Object)this.outputFunction);
            pel.pageStarted(event);
        }
    }

    private void firePageFinishedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        if (activeLevel == -2 && this.outputFunctionIsPageListener) {
            PageEventListener pel = (PageEventListener)((Object)this.outputFunction);
            pel.pageFinished(event);
        }
    }
}

