/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.DataRow;

public final class LegacyDataRowWrapper {
    private DataRow parent;

    public DataRow getParent() {
        return this.parent;
    }

    public void setParent(DataRow parent) {
        this.parent = parent;
    }

    public Object get(int col) {
        if (this.parent == null) {
            return null;
        }
        String name = this.getColumnName(col);
        if (name == null) {
            return null;
        }
        return this.parent.get(name);
    }

    public Object get(String col) {
        if (this.parent == null) {
            return null;
        }
        return this.parent.get(col);
    }

    public String getColumnName(int col) {
        if (this.parent == null) {
            return null;
        }
        String[] columnNames = this.parent.getColumnNames();
        return columnNames[col];
    }

    public int findColumn(String name) {
        if (this.parent == null) {
            return -1;
        }
        return Arrays.asList(this.parent.getColumnNames()).indexOf(name);
    }

    public int getColumnCount() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getColumnNames().length;
    }

    public boolean isChanged(String name) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isChanged(name);
    }

    public boolean isChanged(int index) {
        if (this.parent == null) {
            return false;
        }
        String name = this.getColumnName(index);
        if (name == null) {
            return false;
        }
        return this.parent.isChanged(name);
    }
}

