/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public class QueryDataRowWrapper
implements DataRow {
    private DataRow backend;
    private Integer queryTimeout;
    private Integer queryLimit;

    public QueryDataRowWrapper(DataRow backend, Integer queryTimeout, Integer queryLimit) {
        if (backend == null) {
            throw new NullPointerException();
        }
        this.backend = backend;
        this.queryTimeout = queryTimeout;
        this.queryLimit = queryLimit;
    }

    public QueryDataRowWrapper(DataRow backend, int queryLimit, int queryTimeout) {
        if (backend == null) {
            throw new NullPointerException();
        }
        this.backend = backend;
        this.queryTimeout = IntegerCache.getInteger(queryTimeout);
        this.queryLimit = IntegerCache.getInteger(queryLimit);
    }

    public Object get(String col) {
        if ("::org.pentaho.reporting::query-limit".equals(col)) {
            return this.queryLimit;
        }
        if ("::org.pentaho.reporting::query-timeout".equals(col)) {
            return this.queryTimeout;
        }
        return this.backend.get(col);
    }

    public String[] getColumnNames() {
        String[] cols = this.backend.getColumnNames();
        String[] retval = new String[cols.length + 2];
        System.arraycopy(cols, 0, retval, 2, cols.length);
        retval[0] = "::org.pentaho.reporting::query-limit";
        retval[1] = "::org.pentaho.reporting::query-timeout";
        return retval;
    }

    public boolean isChanged(String name) {
        if ("::org.pentaho.reporting::query-limit".equals(name)) {
            return false;
        }
        if ("::org.pentaho.reporting::query-timeout".equals(name)) {
            return false;
        }
        return this.backend.isChanged(name);
    }
}

