/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import java.util.Map;
import java.util.Set;
import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheetCollection;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.ReportProperties;

public class ReportDefinitionImpl
extends Section
implements ReportDefinition {
    private ReportHeader reportHeader;
    private ReportFooter reportFooter;
    private PageHeader pageHeader;
    private PageFooter pageFooter;
    private Watermark watermark;
    private ReportProperties properties;
    private StyleSheetCollection styleSheetCollection;
    private PageDefinition pageDefinition;
    private String query;
    private Group rootGroup;
    private int queryLimit;
    private int queryTimeout;

    public ReportDefinitionImpl(ReportDefinition report, PageDefinition pageDefinition) throws ReportProcessingException {
        super(report.getObjectID());
        if (pageDefinition == null) {
            throw new NullPointerException();
        }
        try {
            this.properties = (ReportProperties)report.getProperties().clone();
            this.rootGroup = (Group)report.getRootGroup().derive(true);
            this.reportFooter = (ReportFooter)report.getReportFooter().derive(true);
            this.reportHeader = (ReportHeader)report.getReportHeader().derive(true);
            this.pageFooter = (PageFooter)report.getPageFooter().derive(true);
            this.pageHeader = (PageHeader)report.getPageHeader().derive(true);
            this.watermark = (Watermark)report.getWatermark().derive(true);
            this.pageDefinition = pageDefinition;
            this.styleSheetCollection = (StyleSheetCollection)report.getStyleSheetCollection().clone();
            this.query = report.getQuery();
            String[] attributeNamespaces = report.getAttributeNamespaces();
            for (int i = 0; i < attributeNamespaces.length; ++i) {
                String namespace = attributeNamespaces[i];
                String[] attributeNames = report.getAttributeNames(namespace);
                for (int j = 0; j < attributeNames.length; ++j) {
                    String name = attributeNames[j];
                    this.setAttribute(namespace, name, report.getAttribute(namespace, name), false);
                }
            }
            String[] attrExprNamespaces = report.getAttributeExpressionNamespaces();
            for (int i = 0; i < attrExprNamespaces.length; ++i) {
                String namespace = attrExprNamespaces[i];
                String[] attributeNames = report.getAttributeExpressionNames(namespace);
                for (int j = 0; j < attributeNames.length; ++j) {
                    String name = attributeNames[j];
                    this.setAttributeExpression(namespace, name, report.getAttributeExpression(namespace, name));
                }
            }
            ElementStyleSheet styleSheet = report.getStyle();
            StyleKey[] styleKeys = styleSheet.getPropertyKeys();
            for (int i = 0; i < styleKeys.length; ++i) {
                StyleKey styleKey = styleKeys[i];
                if (styleKey == null) continue;
                this.getStyle().setStyleProperty(styleKey, styleSheet.getStyleProperty(styleKey));
            }
            Set styleExpressionEntries = report.getStyleExpressions().entrySet();
            for (Map.Entry entry : styleExpressionEntries) {
                this.setStyleExpression((StyleKey)entry.getKey(), (Expression)entry.getValue());
            }
        }
        catch (CloneNotSupportedException cne) {
            throw new ReportProcessingException("Cloning failed", cne);
        }
        this.registerAsChild(this.rootGroup);
        this.registerAsChild(this.reportHeader);
        this.registerAsChild(this.reportFooter);
        this.registerAsChild(this.pageHeader);
        this.registerAsChild(this.pageFooter);
        this.registerAsChild(this.watermark);
        this.queryLimit = report.getQueryLimit();
        this.queryTimeout = report.getQueryTimeout();
        this.setName(report.getName());
    }

    public int getQueryLimit() {
        return this.queryLimit;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public String getQuery() {
        return this.query;
    }

    public ReportHeader getReportHeader() {
        return this.reportHeader;
    }

    public ReportFooter getReportFooter() {
        return this.reportFooter;
    }

    public PageHeader getPageHeader() {
        return this.pageHeader;
    }

    public PageFooter getPageFooter() {
        return this.pageFooter;
    }

    public ItemBand getItemBand() {
        Group group = this.getInnerMostGroup();
        GroupDataBody dataBody = (GroupDataBody)group.getBody();
        return dataBody.getItemBand();
    }

    public DetailsHeader getDetailsHeader() {
        Group group = this.getInnerMostGroup();
        GroupDataBody dataBody = (GroupDataBody)group.getBody();
        return dataBody.getDetailsHeader();
    }

    public DetailsFooter getDetailsFooter() {
        Group group = this.getInnerMostGroup();
        GroupDataBody dataBody = (GroupDataBody)group.getBody();
        return dataBody.getDetailsFooter();
    }

    public Group getRootGroup() {
        return this.rootGroup;
    }

    private Group getInnerMostGroup() {
        Group existingGroup = this.rootGroup;
        GroupBody gb = existingGroup.getBody();
        while (gb != null) {
            int count = gb.getElementCount();
            GroupBody locatedBody = null;
            for (int i = 0; i < count; ++i) {
                ReportElement element = gb.getElement(i);
                if (!(element instanceof Group)) continue;
                existingGroup = (Group)element;
                locatedBody = existingGroup.getBody();
                break;
            }
            if (locatedBody == null) {
                gb = null;
                continue;
            }
            gb = locatedBody;
        }
        return existingGroup;
    }

    public NoDataBand getNoDataBand() {
        Group group = this.getInnerMostGroup();
        GroupDataBody dataBody = (GroupDataBody)group.getBody();
        return dataBody.getNoDataBand();
    }

    public ReportProperties getProperties() {
        return this.properties;
    }

    public int getGroupCount() {
        int result = 1;
        Group existingGroup = this.rootGroup;
        GroupBody gb = existingGroup.getBody();
        while (gb != null) {
            int count = gb.getElementCount();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                ReportElement element = gb.getElement(i);
                if (!(element instanceof Group)) continue;
                existingGroup = (Group)element;
                ++result;
                gb = existingGroup.getBody();
                found = true;
                break;
            }
            if (found) continue;
            gb = null;
        }
        return result;
    }

    public Group getGroup(int groupIndex) {
        if (groupIndex < 0) {
            throw new IllegalArgumentException("GroupCount must not be negative");
        }
        if (groupIndex == 0) {
            return this.rootGroup;
        }
        int result = 0;
        Group existingGroup = this.rootGroup;
        GroupBody gb = existingGroup.getBody();
        while (gb != null) {
            int count = gb.getElementCount();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                ReportElement element = gb.getElement(i);
                if (!(element instanceof Group)) continue;
                existingGroup = (Group)element;
                if (++result == groupIndex) {
                    return existingGroup;
                }
                gb = existingGroup.getBody();
                found = true;
                break;
            }
            if (found) continue;
            gb = null;
        }
        throw new IndexOutOfBoundsException("No group defined at the given index " + groupIndex + " . Max-index=" + result);
    }

    public Object clone() throws CloneNotSupportedException {
        ReportDefinitionImpl report = (ReportDefinitionImpl)super.clone();
        report.rootGroup = (Group)this.rootGroup.clone();
        report.pageFooter = (PageFooter)this.pageFooter.clone();
        report.pageHeader = (PageHeader)this.pageHeader.clone();
        report.properties = (ReportProperties)this.properties.clone();
        report.reportFooter = (ReportFooter)this.reportFooter.clone();
        report.reportHeader = (ReportHeader)this.reportHeader.clone();
        report.watermark = (Watermark)this.watermark.clone();
        report.pageDefinition = this.pageDefinition;
        report.styleSheetCollection = (StyleSheetCollection)this.styleSheetCollection.clone();
        report.registerAsChild(report.rootGroup);
        report.registerAsChild(report.reportHeader);
        report.registerAsChild(report.reportFooter);
        report.registerAsChild(report.pageHeader);
        report.registerAsChild(report.pageFooter);
        report.registerAsChild(report.watermark);
        return report;
    }

    public Element derive(boolean preserveElementInstanceIds) throws CloneNotSupportedException {
        ReportDefinitionImpl report = (ReportDefinitionImpl)super.derive(preserveElementInstanceIds);
        report.properties = (ReportProperties)this.properties.clone();
        report.rootGroup = (Group)this.rootGroup.derive(preserveElementInstanceIds);
        report.pageFooter = (PageFooter)this.pageFooter.derive(preserveElementInstanceIds);
        report.pageHeader = (PageHeader)this.pageHeader.derive(preserveElementInstanceIds);
        report.reportFooter = (ReportFooter)this.reportFooter.derive(preserveElementInstanceIds);
        report.reportHeader = (ReportHeader)this.reportHeader.derive(preserveElementInstanceIds);
        report.watermark = (Watermark)this.watermark.derive(preserveElementInstanceIds);
        report.pageDefinition = this.pageDefinition;
        report.styleSheetCollection = (StyleSheetCollection)this.styleSheetCollection.clone();
        report.registerAsChild(report.rootGroup);
        report.registerAsChild(report.reportHeader);
        report.registerAsChild(report.reportFooter);
        report.registerAsChild(report.pageHeader);
        report.registerAsChild(report.pageFooter);
        report.registerAsChild(report.watermark);
        return report;
    }

    public StyleSheetCollection getStyleSheetCollection() {
        return this.styleSheetCollection;
    }

    public Watermark getWatermark() {
        return this.watermark;
    }

    public PageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    public ReportDefinition getReportDefinition() {
        return this;
    }

    protected void removeElement(Element element) {
        throw new UnsupportedOperationException("Method 'removeElement' is not supported in the read-only report-definition.");
    }

    public void setElementAt(int position, Element element) {
        throw new UnsupportedOperationException("Method 'removeElement' is not supported in the read-only report-definition.");
    }

    public int getElementCount() {
        return 6;
    }

    public ReportElement getElement(int index) {
        switch (index) {
            case 0: {
                return this.pageHeader;
            }
            case 1: {
                return this.reportHeader;
            }
            case 2: {
                return this.rootGroup;
            }
            case 3: {
                return this.reportFooter;
            }
            case 4: {
                return this.pageFooter;
            }
            case 5: {
                return this.watermark;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public SubReport findSubReport(InstanceID reportID) {
        ReportElement element = FunctionUtilities.findElementByInstanceId(this, reportID);
        if (element instanceof SubReport) {
            return (SubReport)element;
        }
        return null;
    }
}

