/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import org.pentaho.reporting.engine.classic.core.event.ReportEvent;

public class ReportStateKey {
    private ReportStateKey parent;
    private int cursor;
    private int crosstabPadding;
    private int stateCode;
    private int groupLevel;
    private int subreport;
    private Integer hashCode;
    private int sequenceCounter;
    private boolean restoreState;

    public ReportStateKey() {
    }

    public ReportStateKey(ReportStateKey parent, int cursor, int crosstabPadding, int stateCode, int groupLevel, int subreport, int sequenceCounter, boolean restoreState) {
        this.parent = parent;
        this.cursor = cursor;
        this.crosstabPadding = crosstabPadding;
        this.stateCode = stateCode;
        this.groupLevel = groupLevel;
        this.subreport = subreport;
        this.sequenceCounter = sequenceCounter;
        this.restoreState = restoreState;
    }

    public int getSequenceCounter() {
        return this.sequenceCounter;
    }

    public int getCrosstabPadding() {
        return this.crosstabPadding;
    }

    public ReportStateKey getParent() {
        return this.parent;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getStateCode() {
        return this.stateCode;
    }

    public int getGroupLevel() {
        return this.groupLevel;
    }

    public int getSubreport() {
        return this.subreport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportStateKey that = (ReportStateKey)o;
        if (this.restoreState != that.restoreState) {
            return false;
        }
        if (this.cursor != that.cursor) {
            return false;
        }
        if (this.crosstabPadding != that.crosstabPadding) {
            return false;
        }
        if (this.groupLevel != that.groupLevel) {
            return false;
        }
        if (this.stateCode != that.stateCode) {
            return false;
        }
        if (this.subreport != that.subreport) {
            return false;
        }
        return !(this.parent != null ? !this.parent.equals(that.parent) : that.parent != null);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 29 * result + this.cursor;
            result = 29 * result + this.crosstabPadding;
            result = 29 * result + this.stateCode;
            result = 29 * result + this.groupLevel;
            result = 29 * result + this.subreport;
            result = 29 * result + (this.restoreState ? 1 : 0);
            this.hashCode = new Integer(result);
            return result;
        }
        return this.hashCode;
    }

    public String toString() {
        return "ReportStateKey{sc=" + this.sequenceCounter + ", cursor=" + this.cursor + ", groupLevel=" + this.groupLevel + ", subreport=" + this.subreport + ", stateCode=" + ReportEvent.translateStateCode(this.stateCode) + ", restoreState=" + this.restoreState + ", stateCodeRaw=" + this.stateCode + ", crosstabPadding=" + this.crosstabPadding + ", parent=" + this.parent + '}';
    }
}

