/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.states.LayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.util.ReportProperties;
import org.pentaho.reporting.engine.classic.core.util.beans.DateValueConverter;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateUtilities {
    private StateUtilities() {
    }

    public static void computeLevels(DefaultFlowController report, LayoutProcess lp, HashSet<Integer> levels) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (lp == null) {
            throw new NullPointerException();
        }
        if (levels == null) {
            throw new NullPointerException();
        }
        StructureFunction[] collectionFunctions = lp.getCollectionFunctions();
        for (int i = 0; i < collectionFunctions.length; ++i) {
            StructureFunction function = collectionFunctions[i];
            if (function.getDependencyLevel() == Integer.MAX_VALUE) continue;
            levels.add(IntegerCache.getInteger(function.getDependencyLevel()));
        }
        levels.add(IntegerCache.getInteger(-2));
        Expression[] expressions = report.getMasterRow().getExpressionDataRow().getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            Expression expression = expressions[i];
            levels.add(IntegerCache.getInteger(expression.getDependencyLevel()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationResult validate(MasterReport report, ValidationResult result) throws ReportProcessingException {
        ReportParameterDefinition parameters = report.getParameterDefinition();
        DefaultParameterContext parameterContext = new DefaultParameterContext(report);
        parameterContext.open();
        try {
            ReportParameterValidator reportParameterValidator = parameters.getValidator();
            ValidationResult validationResult = reportParameterValidator.validate(result, parameters, parameterContext);
            return validationResult;
        }
        finally {
            parameterContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportParameterValues computeParameterValueSet(MasterReport report) throws ReportProcessingException {
        ReportParameterDefinition parameters = report.getParameterDefinition();
        DefaultParameterContext parameterContext = new DefaultParameterContext(report);
        parameterContext.open();
        try {
            ReportParameterValidator reportParameterValidator = parameters.getValidator();
            ValidationResult validationResult = reportParameterValidator.validate(new ValidationResult(), parameters, parameterContext);
            ReportParameterValues parameterValues = validationResult.getParameterValues();
            ReportParameterValues reportParameterValues = StateUtilities.computeParameterValueSet(report, parameterValues);
            return reportParameterValues;
        }
        finally {
            parameterContext.close();
        }
    }

    public static ReportParameterValues computeParameterValueSet(MasterReport report, ReportParameterValues parameterValues) throws ReportProcessingException {
        ReportParameterValues retval = new ReportParameterValues();
        ReportProperties reportProperties = report.getProperties();
        String[] propertyKeys = reportProperties.keyArray();
        for (int i = 0; i < propertyKeys.length; ++i) {
            String string = propertyKeys[i];
            retval.put(string, reportProperties.get(string));
        }
        retval.putAll(parameterValues);
        ReportEnvironment reportEnvironment = report.getReportEnvironment();
        Date property = StateUtilities.tryParse(reportEnvironment.getEnvironmentProperty("::internal::report.date"));
        if (property == null) {
            retval.put("report.date", new Date());
        } else {
            retval.put("report.date", property);
        }
        return retval;
    }

    private static Date tryParse(String value) {
        try {
            if (value == null) {
                return null;
            }
            return (Date)new DateValueConverter().toPropertyValue(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ReportParameterValues computeParameterValueSet(SubReport report) {
        ReportParameterValues retval = new ReportParameterValues();
        retval.put("report.date", new Date());
        ParameterMapping[] reportParameterValues = report.getInputMappings();
        for (int i = 0; i < reportParameterValues.length; ++i) {
            ParameterMapping mapping = reportParameterValues[i];
            if ("*".equals(mapping.getName())) continue;
            retval.put(mapping.getName(), null);
        }
        return retval;
    }

    public static int findGroupByName(ReportDefinition definition, String groupName) {
        int count = definition.getGroupCount();
        for (int i = 0; i < count; ++i) {
            Group group = definition.getGroup(i);
            if (!ObjectUtilities.equal((Object)groupName, (Object)group.getName())) continue;
            return i;
        }
        return -1;
    }

    public static final class DescendingComparator
    implements Comparator,
    Serializable {
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Comparable)) {
                throw new ClassCastException("Need comparable Elements");
            }
            if (!(o2 instanceof Comparable)) {
                throw new ClassCastException("Need comparable Elements");
            }
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return -1 * c1.compareTo(c2);
        }
    }
}

