/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.states.LayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.datarow.InlineDataRowRuntime;

public class SubLayoutProcess
implements LayoutProcess {
    private InlineDataRowRuntime inlineDataRowRuntime;
    private StructureFunction[] collectionFunctions;
    private boolean[] collectionFunctionIsPageListener;
    private boolean hasPageListener;
    private LayoutProcess parent;

    public SubLayoutProcess(LayoutProcess parent, StructureFunction[] structureFunctions) {
        if (structureFunctions == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.collectionFunctions = (StructureFunction[])structureFunctions.clone();
        this.reinit();
    }

    public LayoutProcess getParent() {
        return this.parent;
    }

    private void reinit() {
        this.collectionFunctionIsPageListener = new boolean[this.collectionFunctions.length];
        this.hasPageListener = this.parent != null ? this.parent.isPageListener() : false;
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction fn = this.collectionFunctions[i];
            if (!(fn instanceof PageEventListener)) continue;
            this.collectionFunctionIsPageListener[i] = true;
            this.hasPageListener = true;
        }
    }

    public boolean isPageListener() {
        return this.hasPageListener;
    }

    public OutputFunction getOutputFunction() {
        return this.parent.getOutputFunction();
    }

    public void restart(ReportState state) throws ReportProcessingException {
        this.parent.restart(state);
    }

    public StructureFunction[] getCollectionFunctions() {
        return (StructureFunction[])this.collectionFunctions.clone();
    }

    public LayoutProcess deriveForStorage() {
        try {
            SubLayoutProcess lp = (SubLayoutProcess)super.clone();
            if (this.parent != null) {
                lp.parent = this.parent.deriveForStorage();
            }
            lp.inlineDataRowRuntime = null;
            lp.collectionFunctions = (StructureFunction[])this.collectionFunctions.clone();
            for (int i = 0; i < this.collectionFunctions.length; ++i) {
                this.collectionFunctions[i] = (StructureFunction)this.collectionFunctions[i].clone();
            }
            return lp;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public LayoutProcess deriveForPagebreak() {
        try {
            SubLayoutProcess lp = (SubLayoutProcess)super.clone();
            if (this.parent != null) {
                lp.parent = this.parent.deriveForPagebreak();
            }
            lp.inlineDataRowRuntime = null;
            lp.collectionFunctions = (StructureFunction[])this.collectionFunctions.clone();
            lp.inlineDataRowRuntime = null;
            for (int i = 0; i < this.collectionFunctions.length; ++i) {
                this.collectionFunctions[i] = (StructureFunction)this.collectionFunctions[i].clone();
            }
            return lp;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SubLayoutProcess lp = (SubLayoutProcess)super.clone();
        if (this.parent != null) {
            lp.parent = (LayoutProcess)this.parent.clone();
        }
        lp.inlineDataRowRuntime = null;
        lp.collectionFunctions = (StructureFunction[])this.collectionFunctions.clone();
        lp.inlineDataRowRuntime = null;
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            this.collectionFunctions[i] = (StructureFunction)this.collectionFunctions[i].clone();
        }
        return lp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireReportEvent(ReportEvent event) {
        block19: {
            StructureFunction function;
            int i;
            int type = event.getType();
            ExpressionRuntime[] oldRuntimes = new ExpressionRuntime[this.collectionFunctions.length];
            for (i = 0; i < this.collectionFunctions.length; ++i) {
                function = this.collectionFunctions[i];
                oldRuntimes[i] = function.getRuntime();
            }
            if (this.inlineDataRowRuntime == null) {
                this.inlineDataRowRuntime = new InlineDataRowRuntime();
            }
            this.inlineDataRowRuntime.setState(event.getState());
            for (i = 0; i < this.collectionFunctions.length; ++i) {
                function = this.collectionFunctions[i];
                function.setRuntime(this.inlineDataRowRuntime);
            }
            try {
                if ((type & 2) == 2) {
                    this.firePageStartedEvent(event);
                    break block19;
                }
                if ((type & 0x400) == 1024) {
                    this.firePageFinishedEvent(event);
                    break block19;
                }
                if ((type & 0x20) == 32) {
                    this.fireItemsAdvancedEvent(event);
                    break block19;
                }
                if ((type & 0x40) == 64) {
                    this.fireItemsFinishedEvent(event);
                    break block19;
                }
                if ((type & 0x10) == 16) {
                    this.fireItemsStartedEvent(event);
                    break block19;
                }
                if ((type & 0x80) == 128) {
                    this.fireGroupFinishedEvent(event);
                    break block19;
                }
                if ((type & 8) == 8) {
                    this.fireGroupStartedEvent(event);
                    break block19;
                }
                if ((type & 1) == 1) {
                    this.fireReportInitializedEvent(event);
                    break block19;
                }
                if ((type & 0x200) == 512) {
                    this.fireReportDoneEvent(event);
                    break block19;
                }
                if ((type & 0x100) == 256) {
                    this.fireReportFinishedEvent(event);
                    break block19;
                }
                if ((type & 4) == 4) {
                    this.fireReportStartedEvent(event);
                    break block19;
                }
                throw new IllegalArgumentException();
            }
            finally {
                for (i = 0; i < this.collectionFunctions.length; ++i) {
                    function = this.collectionFunctions[i];
                    function.setRuntime(oldRuntimes[i]);
                }
            }
        }
        if (this.parent != null) {
            this.parent.fireReportEvent(event);
        }
    }

    private void fireItemsAdvancedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel()) continue;
            function.itemsAdvanced(event);
        }
    }

    private void fireItemsStartedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel()) continue;
            function.itemsStarted(event);
        }
    }

    private void fireItemsFinishedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel()) continue;
            function.itemsFinished(event);
        }
    }

    private void fireGroupStartedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel()) continue;
            function.groupStarted(event);
        }
    }

    private void fireGroupFinishedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel()) continue;
            function.groupFinished(event);
        }
    }

    private void fireReportStartedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel()) continue;
            function.reportStarted(event);
        }
    }

    private void fireReportDoneEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel()) continue;
            function.reportDone(event);
        }
    }

    private void fireReportFinishedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel()) continue;
            function.reportFinished(event);
        }
    }

    private void fireReportInitializedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel()) continue;
            function.reportInitialized(event);
        }
    }

    private void firePageStartedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel() || !this.collectionFunctionIsPageListener[i]) continue;
            PageEventListener pel = (PageEventListener)((Object)function);
            pel.pageStarted(event);
        }
    }

    private void firePageFinishedEvent(ReportEvent event) {
        int activeLevel = event.getState().getLevel();
        for (int i = 0; i < this.collectionFunctions.length; ++i) {
            StructureFunction function = this.collectionFunctions[i];
            if (activeLevel > function.getDependencyLevel() || !this.collectionFunctionIsPageListener[i]) continue;
            PageEventListener pel = (PageEventListener)((Object)function);
            pel.pageFinished(event);
        }
    }
}

