/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.crosstab;

import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.crosstab.OrderedMergeCrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.crosstab.SortedMergeCrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class CrosstabProcessorFunction
extends AbstractFunction
implements StructureFunction {
    private FastStack processingStack;
    private HashMap results;
    private boolean resultsFinished;

    public int getProcessingPriority() {
        return Short.MIN_VALUE;
    }

    public void reportStarted(ReportEvent event) {
        if (event.getState().isSubReportEvent()) {
            if (this.processingStack == null || this.processingStack.isEmpty()) {
                return;
            }
            this.processingStack.push(null);
        }
    }

    public void reportDone(ReportEvent event) {
        if (event.getState().isSubReportEvent()) {
            if (this.processingStack == null || this.processingStack.isEmpty()) {
                return;
            }
            Object o = this.processingStack.pop();
            if (o != null) {
                throw new IllegalStateException("Expected to find 'start-subreport' marker, but got " + o + " instead.");
            }
        } else {
            this.resultsFinished = true;
        }
    }

    public void groupStarted(ReportEvent event) {
        ReportState state = event.getState();
        if (event.getLevel() == this.getDependencyLevel()) {
            Group group = event.getReport().getGroup(state.getCurrentGroupIndex());
            if (group instanceof CrosstabGroup) {
                DefaultDataAttributeContext context;
                CrosstabGroup crosstabGroup = (CrosstabGroup)group;
                if (this.processingStack == null) {
                    this.processingStack = new FastStack();
                }
                String[] columnSet = this.computeColumns(crosstabGroup);
                ReportStateKey processKey = state.getProcessKey();
                DataSchema dataSchema = this.getRuntime().getDataSchema();
                DataAttributes tableAttributes = dataSchema.getTableAttributes();
                String mode = (String)tableAttributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "crosstab-mode", String.class, context = new DefaultDataAttributeContext(this.getRuntime().getProcessingContext().getOutputProcessorMetaData(), this.getRuntime().getResourceBundleFactory().getLocale()));
                if ("normalized".equals(mode)) {
                    this.processingStack.push((Object)new OrderedMergeCrosstabSpecification(processKey, columnSet));
                } else {
                    this.processingStack.push((Object)new SortedMergeCrosstabSpecification(processKey, columnSet));
                }
                return;
            }
            if (this.processingStack == null || this.processingStack.isEmpty()) {
                return;
            }
            CrosstabSpecification csstate = (CrosstabSpecification)this.processingStack.peek();
            if (csstate == null) {
                return;
            }
            if (group instanceof CrosstabRowGroup && group.getBody() instanceof CrosstabColumnGroupBody) {
                csstate.startRow();
            }
            return;
        }
        if (this.results == null || this.processingStack == null || this.processingStack.isEmpty()) {
            return;
        }
        Group group = event.getReport().getGroup(state.getCurrentGroupIndex());
        if (group instanceof CrosstabGroup) {
            ReportStateKey processKey = state.getProcessKey();
            CrosstabSpecification o = (CrosstabSpecification)this.results.get(processKey);
            if (o == null) {
                throw new IllegalStateException("Expected crosstab result, but got nothing at all");
            }
            this.processingStack.push((Object)o);
        }
    }

    public void groupFinished(ReportEvent event) {
        if (this.processingStack == null || this.processingStack.isEmpty()) {
            return;
        }
        CrosstabSpecification csstate = (CrosstabSpecification)this.processingStack.peek();
        if (csstate == null) {
            return;
        }
        ReportState state = event.getState();
        if (event.getLevel() == this.getDependencyLevel()) {
            Group group = event.getReport().getGroup(state.getCurrentGroupIndex());
            if (group instanceof CrosstabGroup) {
                CrosstabSpecification cs = (CrosstabSpecification)this.processingStack.pop();
                if (this.results == null) {
                    this.results = new HashMap();
                }
                this.results.put(cs.getKey(), cs);
                return;
            }
            if (group instanceof CrosstabRowGroup && group.getBody() instanceof CrosstabColumnGroupBody) {
                csstate.endRow();
            }
            return;
        }
        if (this.results == null) {
            return;
        }
        Group group = event.getReport().getGroup(state.getCurrentGroupIndex());
        if (group instanceof CrosstabGroup) {
            this.processingStack.pop();
        }
    }

    private String[] computeColumns(CrosstabGroup crosstabGroup) {
        ArrayList<String> list = new ArrayList<String>();
        GroupBody body = crosstabGroup.getBody();
        while (body != null) {
            Group otherGroup;
            GroupBody cogb;
            if (body instanceof SubGroupBody) {
                SubGroupBody sgBody = (SubGroupBody)body;
                Group g = sgBody.getGroup();
                body = g.getBody();
                continue;
            }
            if (body instanceof CrosstabOtherGroupBody) {
                cogb = (CrosstabOtherGroupBody)body;
                otherGroup = ((CrosstabOtherGroupBody)cogb).getGroup();
                if (((CrosstabOtherGroup)otherGroup).getField() != null) {
                    list.add(((CrosstabOtherGroup)otherGroup).getField());
                }
                body = otherGroup.getBody();
                continue;
            }
            if (body instanceof CrosstabRowGroupBody) {
                cogb = (CrosstabRowGroupBody)body;
                otherGroup = ((CrosstabRowGroupBody)cogb).getGroup();
                if (((CrosstabRowGroup)otherGroup).getField() != null) {
                    list.add(((CrosstabRowGroup)otherGroup).getField());
                }
                body = otherGroup.getBody();
                continue;
            }
            if (!(body instanceof CrosstabColumnGroupBody)) break;
            cogb = (CrosstabColumnGroupBody)body;
            otherGroup = ((CrosstabColumnGroupBody)cogb).getGroup();
            if (((CrosstabColumnGroup)otherGroup).getField() != null) {
                list.add(((CrosstabColumnGroup)otherGroup).getField());
            }
            body = otherGroup.getBody();
        }
        return list.toArray(new String[list.size()]);
    }

    public void itemsAdvanced(ReportEvent event) {
        if (event.getLevel() == this.getDependencyLevel()) {
            if (this.processingStack == null || this.processingStack.isEmpty()) {
                return;
            }
            CrosstabSpecification state = (CrosstabSpecification)this.processingStack.peek();
            if (state == null) {
                return;
            }
            state.add(this.getDataRow());
        }
    }

    public Object getValue() {
        if (this.processingStack == null || this.processingStack.isEmpty()) {
            return null;
        }
        if (!this.resultsFinished) {
            return null;
        }
        return this.processingStack.peek();
    }

    public boolean isDeepTraversing() {
        return false;
    }

    public int getDependencyLevel() {
        return Integer.MAX_VALUE;
    }

    public Object clone() throws CloneNotSupportedException {
        CrosstabProcessorFunction cps = (CrosstabProcessorFunction)super.clone();
        if (this.processingStack == null || this.processingStack.isEmpty()) {
            return cps;
        }
        cps.processingStack = (FastStack)this.processingStack.clone();
        return cps;
    }

    public Expression getInstance() {
        CrosstabProcessorFunction cps = (CrosstabProcessorFunction)super.getInstance();
        cps.resultsFinished = false;
        cps.results = null;
        cps.processingStack = null;
        return cps;
    }
}

