/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.crosstab;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabKeyComparator;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SortedMergeCrosstabSpecification
implements CrosstabSpecification {
    private int insertationCursor;
    private ArrayList entries;
    private String[] columnSet;
    private CrosstabKeyComparator comparator;
    private ReportStateKey key;

    public SortedMergeCrosstabSpecification(ReportStateKey key, String[] columnSet) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (columnSet == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.columnSet = (String[])columnSet.clone();
        this.entries = new ArrayList();
        this.comparator = new CrosstabKeyComparator();
    }

    public int indexOf(int start, Object[] key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException();
        }
        int size = this.entries.size();
        for (int i = start; i < size; ++i) {
            Object[] objects = (Object[])this.entries.get(i);
            if (!ObjectUtilities.equalArray((Object[])key, (Object[])objects)) continue;
            return i;
        }
        return -1;
    }

    public String[] getColumnNames() {
        return (String[])this.columnSet.clone();
    }

    public ReportStateKey getKey() {
        return this.key;
    }

    public void startRow() {
        this.insertationCursor = 0;
    }

    public void endRow() {
    }

    public void add(DataRow dataRow) {
        Object[] newKey = new Object[this.columnSet.length];
        for (int i = 0; i < this.columnSet.length; ++i) {
            String columnName = this.columnSet[i];
            newKey[i] = dataRow.get(columnName);
        }
        while (this.entries.size() > this.insertationCursor) {
            Object[] existingKey = (Object[])this.entries.get(this.insertationCursor);
            int result = this.comparator.compare(newKey, existingKey);
            if (result == 0) {
                return;
            }
            if (result < 0) break;
            ++this.insertationCursor;
        }
        this.entries.add(this.insertationCursor, newKey);
    }

    public int size() {
        return this.entries.size();
    }

    public Object[] getKeyAt(int column) {
        Object[] data = (Object[])this.entries.get(column);
        return (Object[])data.clone();
    }
}

