/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.states.DefaultGroupingState;
import org.pentaho.reporting.engine.classic.core.states.GroupingState;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRowChangeEvent;
import org.pentaho.reporting.engine.classic.core.util.IntList;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.LevelList;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.libraries.base.config.Configuration;

public final class ExpressionDataRow {
    private static final Log logger = LogFactory.getLog(ExpressionDataRow.class);
    private static final Integer[] EMPTY_INTEGERARRAY = new Integer[0];
    private static final Expression[] EMPTY_EXPRESSIONS = new Expression[0];
    private MasterDataRow masterRow;
    private ProcessingContext processingContext;
    private int length;
    private Expression[] expressions;
    private LevelStorage[] levelData;
    private MasterDataRowChangeEvent chEvent;
    private DataRowRuntime runtime;
    private ArrayList errorList;
    private static final Exception[] EMPTY_EXCEPTIONS = new Exception[0];
    private boolean prepareEventListener;
    private boolean includeStructuralProcessing;

    public ExpressionDataRow(MasterDataRow masterRow, ProcessingContext processingContext, boolean includeStructuralProcessing) {
        if (masterRow == null) {
            throw new NullPointerException();
        }
        if (processingContext == null) {
            throw new NullPointerException();
        }
        this.includeStructuralProcessing = includeStructuralProcessing;
        this.processingContext = processingContext;
        this.masterRow = masterRow;
        this.expressions = EMPTY_EXPRESSIONS;
        this.chEvent = new MasterDataRowChangeEvent(3, "", "");
        this.runtime = new DataRowRuntime(this);
        this.revalidate();
    }

    public boolean isIncludeStructuralProcessing() {
        return this.includeStructuralProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExpressionDataRow(MasterDataRow masterRow, ExpressionDataRow previousRow, boolean updateGlobalView) throws CloneNotSupportedException {
        this.chEvent = new MasterDataRowChangeEvent(3, "", "");
        this.processingContext = previousRow.processingContext;
        this.masterRow = masterRow;
        this.expressions = new Expression[previousRow.expressions.length];
        this.length = previousRow.length;
        this.levelData = previousRow.levelData;
        this.runtime = new DataRowRuntime(this);
        this.runtime.setState(previousRow.runtime.getState());
        this.includeStructuralProcessing = previousRow.includeStructuralProcessing;
        for (int i = 0; i < this.length; ++i) {
            Object value;
            Expression expression = previousRow.expressions[i];
            if (expression == null) {
                logger.debug((Object)"Error: Expression is null...");
                throw new IllegalStateException();
            }
            this.expressions[i] = expression instanceof Function ? (Expression)expression.clone() : expression;
            if (!updateGlobalView) continue;
            String name = expression.getName();
            if (name != null) {
                this.chEvent.setColumnName(name);
            }
            ExpressionRuntime oldRuntime = expression.getRuntime();
            try {
                expression.setRuntime(this.runtime);
                value = this.runtime.getProcessingContext().getProcessingLevel() <= expression.getDependencyLevel() ? expression.getValue() : null;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)("Failed to evaluate expression '" + name + '\''), (Throwable)e);
                } else {
                    logger.warn((Object)("Failed to evaluate expression '" + name + '\''));
                }
                value = null;
            }
            finally {
                expression.setRuntime(oldRuntime);
            }
            if (name == null) continue;
            this.chEvent.setColumnValue(value);
            masterRow.dataRowChanged(this.chEvent);
        }
    }

    private void pushExpression(Expression expressionSlot, boolean preserveState) throws ReportProcessingException {
        if (expressionSlot == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.length + 1);
        if (!preserveState) {
            this.expressions[this.length] = expressionSlot.getInstance();
        } else {
            try {
                this.expressions[this.length] = (Expression)expressionSlot.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new ReportProcessingException("Failed to clone the expression.", e);
            }
        }
        String name = expressionSlot.getName();
        ++this.length;
        if (name != null) {
            MasterDataRowChangeEvent chEvent = new MasterDataRowChangeEvent(1, name, null);
            this.masterRow.dataRowChanged(chEvent);
        }
    }

    public void pushExpressions(Expression[] expressionSlots, boolean preserveState) throws ReportProcessingException {
        if (expressionSlots == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.length + expressionSlots.length);
        for (int i = 0; i < expressionSlots.length; ++i) {
            Expression expression = expressionSlots[i];
            if (expression == null) continue;
            this.pushExpression(expression, preserveState);
        }
        this.revalidate();
    }

    public void popExpressions(int counter) {
        for (int i = 0; i < counter; ++i) {
            this.popExpression();
        }
        this.revalidate();
    }

    private void popExpression() {
        if (this.length == 0) {
            return;
        }
        Expression removedExpression = this.expressions[this.length - 1];
        String originalName = removedExpression.getName();
        removedExpression.setRuntime(null);
        this.expressions[this.length - 1] = null;
        --this.length;
        if (originalName != null && !removedExpression.isPreserve()) {
            MasterDataRowChangeEvent chEvent = new MasterDataRowChangeEvent(2, originalName, null);
            this.masterRow.dataRowChanged(chEvent);
        }
    }

    private void ensureCapacity(int requestedSize) {
        int capacity = this.expressions.length;
        if (capacity > requestedSize) {
            return;
        }
        int newSize = Math.max(capacity * 2, requestedSize + 10);
        Expression[] newExpressions = new Expression[newSize];
        System.arraycopy(this.expressions, 0, newExpressions, 0, this.length);
        this.expressions = newExpressions;
    }

    private void revalidate() {
        int dependencyLevel;
        Expression expression;
        int i;
        int minLevel = Integer.MIN_VALUE;
        LevelList levelList = new LevelList();
        for (i = 0; i < this.length; ++i) {
            expression = this.expressions[i];
            dependencyLevel = expression.getDependencyLevel();
            levelList.add(IntegerCache.getInteger(i), dependencyLevel);
            if (minLevel >= dependencyLevel) continue;
            minLevel = dependencyLevel;
        }
        if (minLevel > Integer.MIN_VALUE && this.isIncludeStructuralProcessing()) {
            for (i = 0; i < this.length; ++i) {
                expression = this.expressions[i];
                dependencyLevel = expression.getDependencyLevel();
                if (dependencyLevel != minLevel || expression instanceof Function) continue;
                levelList.add(IntegerCache.getInteger(i), minLevel);
            }
        }
        Integer[] levels = levelList.getLevelsDescendingArray();
        this.levelData = new LevelStorage[levels.length];
        int expressionsCount = levelList.size();
        int capacity = Math.min(20, expressionsCount);
        IntList expressionPositions = new IntList(capacity);
        IntList activeExpressions = new IntList(capacity);
        IntList functions = new IntList(capacity);
        IntList pageEventListeners = new IntList(capacity);
        IntList prepareEventListeners = new IntList(capacity);
        boolean prepareEventListener = false;
        for (int i2 = 0; i2 < levels.length; ++i2) {
            int currentLevel = levels[i2];
            Integer[] data = (Integer[])levelList.getElementArrayForLevel(currentLevel, EMPTY_INTEGERARRAY);
            for (int x = 0; x < data.length; ++x) {
                Integer position = data[x];
                Expression ex = this.expressions[position];
                int globalPosition = position;
                expressionPositions.add(globalPosition);
                activeExpressions.add(globalPosition);
                if (!(ex instanceof Function)) continue;
                functions.add(globalPosition);
                if (!(ex instanceof PageEventListener)) continue;
                pageEventListeners.add(globalPosition);
            }
            this.levelData[i2] = new LevelStorage(currentLevel, expressionPositions.toArray(), activeExpressions.toArray(), functions.toArray(), pageEventListeners.toArray(), prepareEventListeners.toArray());
            expressionPositions.clear();
            activeExpressions.clear();
            functions.clear();
            pageEventListeners.clear();
            prepareEventListeners.clear();
            this.prepareEventListener = false;
        }
    }

    public int[] getLevels() {
        int[] retval = new int[this.levelData.length];
        for (int i = 0; i < this.levelData.length; ++i) {
            LevelStorage storage = this.levelData[i];
            retval[i] = storage.getLevelNumber();
        }
        return retval;
    }

    public int getColumnCount() {
        return this.length;
    }

    public void fireReportEvent(ReportEvent event) {
        this.runtime.setState(event.getState().createGroupingState());
        if ((event.getType() & 2) == 2) {
            this.firePageStartedEvent(event);
        } else if ((event.getType() & 0x400) == 1024) {
            this.firePageFinishedEvent(event);
        } else if ((event.getType() & 0x20) == 32) {
            this.fireItemsAdvancedEvent(event);
        } else if ((event.getType() & 0x40) == 64) {
            this.fireItemsFinishedEvent(event);
        } else if ((event.getType() & 0x10) == 16) {
            this.fireItemsStartedEvent(event);
        } else if ((event.getType() & 0x80) == 128) {
            this.fireGroupFinishedEvent(event);
        } else if ((event.getType() & 8) == 8) {
            this.fireGroupStartedEvent(event);
        } else if ((event.getType() & 1) == 1) {
            this.fireReportInitializedEvent(event);
        } else if ((event.getType() & 0x200) == 512) {
            this.fireReportDoneEvent(event);
        } else if ((event.getType() & 0x100) == 256) {
            this.fireReportFinishedEvent(event);
        } else if ((event.getType() & 4) == 4) {
            this.fireReportStartedEvent(event);
        } else {
            throw new IllegalArgumentException();
        }
        this.reactivateExpressions(event.isDeepTraversing());
    }

    private void reactivateExpressions(boolean deepTraversing) {
        int level;
        int rawLevel = this.processingContext.getProcessingLevel();
        int activeLevel = rawLevel == Integer.MAX_VALUE ? (this.levelData.length > 1 ? this.levelData[1].getLevelNumber() : rawLevel) : rawLevel;
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getActiveExpressions();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                expression.setRuntime(this.runtime);
                String name = expression.getName();
                if (name != null) {
                    this.chEvent.setColumnName(name);
                    try {
                        Object value = this.runtime.getProcessingContext().getProcessingLevel() <= expression.getDependencyLevel() ? expression.getValue() : null;
                        this.chEvent.setColumnValue(value);
                    }
                    catch (Exception e) {
                        this.chEvent.setColumnValue(null);
                        logger.info((Object)("Evaluation of expression '" + name + "'failed."), (Throwable)e);
                    }
                    this.masterRow.dataRowChanged(this.chEvent);
                }
                expression.setRuntime(null);
            }
        }
    }

    private void fireItemsAdvancedEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getFunctions();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                Function e = (Function)expression;
                try {
                    e.itemsAdvanced(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire prepare event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire prepare event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireItemsStartedEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getFunctions();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                Function e = (Function)expression;
                try {
                    e.itemsStarted(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire prepare event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire prepare event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireItemsFinishedEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getFunctions();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                Function e = (Function)expression;
                try {
                    e.itemsFinished(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire prepare event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire prepare event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireGroupStartedEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getFunctions();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                Function e = (Function)expression;
                try {
                    e.groupStarted(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire group-started event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire group-started event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireGroupFinishedEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getFunctions();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                Function e = (Function)expression;
                try {
                    e.groupFinished(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire group-finished event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire group-finished event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireReportStartedEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getFunctions();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                Function e = (Function)expression;
                try {
                    e.reportStarted(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire report-started event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire report-started event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireReportDoneEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getFunctions();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                Function e = (Function)expression;
                try {
                    e.reportDone(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire report-done event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire report-done event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireReportFinishedEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getFunctions();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                Function e = (Function)expression;
                try {
                    e.reportFinished(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire report-finished event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire report-finished event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireReportInitializedEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getFunctions();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                Function e = (Function)expression;
                try {
                    e.reportInitialized(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire report-initialized event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire report-initialized event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void firePageStartedEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getPageEventListeners();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                PageEventListener e = (PageEventListener)((Object)expression);
                try {
                    e.pageStarted(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire page-started event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire page-started event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void firePageFinishedEvent(ReportEvent event) {
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.processingContext.getProcessingLevel();
        for (int levelIdx = 0; levelIdx < this.levelData.length && (level = this.levelData[levelIdx].getLevelNumber()) >= activeLevel; ++levelIdx) {
            int[] listeners = this.levelData[levelIdx].getPageEventListeners();
            for (int l = 0; l < listeners.length; ++l) {
                Expression expression = this.expressions[listeners[l]];
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(this.runtime);
                PageEventListener e = (PageEventListener)((Object)expression);
                try {
                    e.pageFinished(event);
                    String name = expression.getName();
                    if (name != null) {
                        this.chEvent.setColumnName(name);
                        this.chEvent.setColumnValue(expression.getValue());
                        this.masterRow.dataRowChanged(this.chEvent);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire page-finished event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire page-finished event: " + ex));
                    }
                    this.addError(ex);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    public ExpressionDataRow derive(MasterDataRow masterRow, boolean update) {
        try {
            return new ExpressionDataRow(masterRow, this, update);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Error on derive(..): ", (Throwable)e);
            throw new IllegalStateException("Cannot clone? Cannot survive!");
        }
    }

    public boolean isErrorOccured() {
        if (this.errorList == null) {
            return false;
        }
        return !this.errorList.isEmpty();
    }

    public void clearErrors() {
        if (this.errorList == null) {
            return;
        }
        this.errorList.clear();
    }

    public Exception[] getErrors() {
        if (this.errorList == null) {
            return EMPTY_EXCEPTIONS;
        }
        return this.errorList.toArray(new Exception[this.errorList.size()]);
    }

    private void addError(Exception e) {
        if (this.errorList == null) {
            this.errorList = new ArrayList();
        }
        this.errorList.add(e);
    }

    public boolean isValid() {
        return this.levelData != null;
    }

    public Expression[] getExpressions() {
        Expression[] retval = new Expression[this.length];
        System.arraycopy(this.expressions, 0, retval, 0, this.length);
        return retval;
    }

    public boolean isPrepareEventListener() {
        return this.prepareEventListener;
    }

    protected MasterDataRow getMasterRow() {
        return this.masterRow;
    }

    protected ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public void refresh() {
        this.reactivateExpressions(false);
    }

    private static class LevelStorage {
        private int levelNumber;
        private int[] activeExpressions;
        private int[] functions;
        private int[] pageEventListeners;
        private int[] prepareEventListeners;
        private int[] expressions;

        protected LevelStorage(int levelNumber, int[] expressions, int[] activeExpressions, int[] functions, int[] pageEventListeners, int[] prepareEventListeners) {
            this.levelNumber = levelNumber;
            this.activeExpressions = activeExpressions;
            this.functions = functions;
            this.pageEventListeners = pageEventListeners;
            this.prepareEventListeners = prepareEventListeners;
            this.expressions = expressions;
        }

        public int getLevelNumber() {
            return this.levelNumber;
        }

        public int[] getFunctions() {
            return this.functions;
        }

        public int[] getActiveExpressions() {
            return this.activeExpressions;
        }

        public int[] getExpressions() {
            return this.expressions;
        }

        public int[] getPageEventListeners() {
            return this.pageEventListeners;
        }

        public int[] getPrepareEventListeners() {
            return this.prepareEventListeners;
        }
    }

    private static class DataRowRuntime
    implements ExpressionRuntime {
        private ExpressionDataRow expressionDataRow;
        private GroupingState state;

        protected DataRowRuntime(ExpressionDataRow dataRow) {
            this.expressionDataRow = dataRow;
            this.state = DefaultGroupingState.EMPTY;
        }

        public DataSchema getDataSchema() {
            return this.expressionDataRow.getMasterRow().getDataSchema();
        }

        public DataRow getDataRow() {
            return this.expressionDataRow.getMasterRow().getGlobalView();
        }

        public Configuration getConfiguration() {
            return this.getProcessingContext().getConfiguration();
        }

        public ResourceBundleFactory getResourceBundleFactory() {
            return this.expressionDataRow.getMasterRow().getResourceBundleFactory();
        }

        public DataFactory getDataFactory() {
            return this.expressionDataRow.getMasterRow().getDataFactory();
        }

        public TableModel getData() {
            return this.expressionDataRow.getMasterRow().getReportDataRow().getReportData();
        }

        public int getCurrentRow() {
            return this.expressionDataRow.getMasterRow().getReportDataRow().getCursor();
        }

        public String getExportDescriptor() {
            return this.getProcessingContext().getExportDescriptor();
        }

        public ProcessingContext getProcessingContext() {
            return this.expressionDataRow.getProcessingContext();
        }

        public int getCurrentGroup() {
            return this.state.getCurrentGroup();
        }

        public int getGroupStartRow(String groupName) {
            return this.state.getGroupStartRow(groupName);
        }

        public int getGroupStartRow(int groupIndex) {
            return this.state.getGroupStartRow(groupIndex);
        }

        public GroupingState getState() {
            return this.state;
        }

        public void setState(GroupingState state) {
            if (state == null) {
                throw new NullPointerException();
            }
            this.state = state;
        }
    }
}

