/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class FastGlobalView
implements DataRow {
    private static final Log logger = LogFactory.getLog(FastGlobalView.class);
    private HashSet duplicateColumns;
    private HashSet invalidColumns;
    private boolean modifiableNameCache;
    private HashMap nameCache;
    private String[] columnNames;
    private Boolean[] columnChanged;
    private Object[] columnValue;
    private Object[] columnOldValue;
    private int[] columnPrev;
    private int length;
    private static final boolean DEBUG = false;
    private boolean warnInvalidColumns;

    public FastGlobalView(FastGlobalView parent) {
        if (parent.modifiableNameCache) {
            this.duplicateColumns = (HashSet)parent.duplicateColumns.clone();
            this.nameCache = (HashMap)parent.nameCache.clone();
            this.modifiableNameCache = false;
            this.columnNames = (String[])parent.columnNames.clone();
        } else {
            this.duplicateColumns = parent.duplicateColumns;
            this.nameCache = parent.nameCache;
            this.columnNames = parent.columnNames;
            this.modifiableNameCache = false;
        }
        this.columnChanged = (Boolean[])parent.columnChanged.clone();
        this.columnValue = (Object[])parent.columnValue.clone();
        this.columnOldValue = (Object[])parent.columnOldValue.clone();
        this.columnPrev = (int[])parent.columnPrev.clone();
        this.length = parent.length;
        this.warnInvalidColumns = parent.warnInvalidColumns;
        this.invalidColumns = parent.invalidColumns;
    }

    public FastGlobalView() {
        this.warnInvalidColumns = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.WarnInvalidColumns"));
        if (this.warnInvalidColumns) {
            this.invalidColumns = new HashSet();
        }
        this.duplicateColumns = new HashSet();
        this.nameCache = new HashMap();
        this.modifiableNameCache = true;
        this.columnNames = new String[20];
        this.columnChanged = new Boolean[20];
        this.columnValue = new Object[20];
        this.columnOldValue = new Object[20];
        this.columnPrev = new int[20];
    }

    public String[] getColumnNames() {
        String[] columnNames = new String[this.length];
        System.arraycopy(this.columnNames, 0, columnNames, 0, this.length);
        return columnNames;
    }

    public Object get(String col) throws IllegalStateException {
        int idx = this.findColumn(col);
        if (idx < 0) {
            if (this.warnInvalidColumns && this.invalidColumns.add(col)) {
                logger.warn((Object)("Warning: Data-Set does not contain a column with name '" + col + '\''));
            }
            return null;
        }
        if (this.columnChanged[idx] != null) {
            return this.columnValue[idx];
        }
        String columnName = this.columnNames[idx];
        if (this.duplicateColumns.contains(columnName)) {
            for (int i = idx - 1; i >= 0; --i) {
                if (!this.columnNames[i].equals(columnName) || this.columnChanged[i] == null) continue;
                return this.columnValue[i];
            }
        }
        return this.columnValue[idx];
    }

    private int findColumn(String name) {
        Integer o = (Integer)this.nameCache.get(name);
        if (o == null) {
            return -1;
        }
        return o;
    }

    public boolean isChanged(String name) {
        int idx = this.findColumn(name);
        if (idx < 0) {
            if (this.warnInvalidColumns && this.invalidColumns.add(name)) {
                logger.warn((Object)("Warning: Data-Set does not contain a column with name '" + name + '\''));
            }
            return false;
        }
        return this.isChanged(idx);
    }

    private boolean isChanged(int col) {
        if (col < 0 || col >= this.length) {
            throw new IndexOutOfBoundsException("Column-Index " + col + " is invalid.");
        }
        Boolean val = this.columnChanged[col];
        if (val != null) {
            return val;
        }
        String columnName = this.columnNames[col];
        if (this.duplicateColumns.contains(columnName)) {
            for (int i = col - 1; i >= 0; --i) {
                if (!this.columnNames[col].equals(columnName) || this.columnChanged[i] == null) continue;
                return this.columnChanged[i];
            }
        }
        throw new IllegalStateException("Checking the 'isChanged' flag before all data for this row is known. This is a error condition that must be checked by the caller.");
    }

    public FastGlobalView derive() {
        return new FastGlobalView(this);
    }

    public FastGlobalView advance() {
        FastGlobalView advanced = new FastGlobalView(this);
        System.arraycopy(advanced.columnValue, 0, advanced.columnOldValue, 0, this.length);
        Arrays.fill((Object[])advanced.columnChanged, null);
        return advanced;
    }

    public void removeColumn(String name) {
        boolean needToRebuildCache;
        int idx = -1;
        if (this.duplicateColumns.contains(name)) {
            needToRebuildCache = true;
            for (int i = this.columnNames.length - 1; i >= 0; --i) {
                if (!ObjectUtilities.equal((Object)name, (Object)this.columnNames[i])) continue;
                idx = i;
                break;
            }
            if (idx < 0) {
                return;
            }
        } else {
            needToRebuildCache = false;
            Integer o = (Integer)this.nameCache.get(name);
            if (o == null) {
                return;
            }
            idx = o;
        }
        if (!this.modifiableNameCache) {
            this.duplicateColumns = (HashSet)this.duplicateColumns.clone();
            this.columnNames = (String[])this.columnNames.clone();
            this.nameCache = (HashMap)this.nameCache.clone();
            this.modifiableNameCache = true;
        }
        if (idx == this.length - 1) {
            this.columnChanged[idx] = null;
            this.columnNames[idx] = null;
            this.columnValue[idx] = null;
            if (this.columnPrev[idx] == -1) {
                this.nameCache.remove(name);
            } else {
                this.nameCache.put(name, IntegerCache.getInteger(this.columnPrev[idx]));
            }
            --this.length;
            if (needToRebuildCache) {
                if (this.columnPrev[idx] == -1) {
                    logger.warn((Object)("Column marked as duplicate but no duplicate index recorded: " + name));
                } else if (this.columnPrev[this.columnPrev[idx]] == -1) {
                    this.duplicateColumns.remove(name);
                }
            }
            return;
        }
        if (this.columnPrev[idx] == -1) {
            this.nameCache.remove(name);
        } else {
            this.nameCache.put(name, IntegerCache.getInteger(this.columnPrev[idx]));
        }
        int moveStartIdx = idx + 1;
        int moveLength = this.length - moveStartIdx;
        System.arraycopy(this.columnNames, moveStartIdx, this.columnNames, idx, moveLength);
        System.arraycopy(this.columnChanged, moveStartIdx, this.columnChanged, idx, moveLength);
        System.arraycopy(this.columnOldValue, moveStartIdx, this.columnOldValue, idx, moveLength);
        System.arraycopy(this.columnValue, moveStartIdx, this.columnValue, idx, moveLength);
        System.arraycopy(this.columnPrev, moveStartIdx, this.columnPrev, idx, moveLength);
        this.columnNames[this.length - 1] = null;
        this.columnChanged[this.length - 1] = null;
        this.columnOldValue[this.length - 1] = null;
        this.columnPrev[this.length - 1] = 0;
        int newLength = moveLength + idx;
        this.nameCache.clear();
        this.duplicateColumns.clear();
        for (int i = 0; i < newLength; ++i) {
            String columnName = this.columnNames[i];
            Integer oldVal = (Integer)this.nameCache.get(columnName);
            if (this.nameCache.containsKey(columnName)) {
                this.duplicateColumns.add(columnName);
            }
            this.nameCache.put(columnName, IntegerCache.getInteger(i));
            this.columnPrev[i] = oldVal != null ? oldVal : -1;
        }
        --this.length;
    }

    public void putField(String name, Object value, boolean update) {
        if (!update) {
            this.addColumn(name, value);
        } else {
            this.updateColumn(name, value);
        }
    }

    private void updateColumn(String name, Object value) {
        Integer o = (Integer)this.nameCache.get(name);
        if (o == null) {
            throw new IllegalStateException("Update to a non-existing column: " + name);
        }
        String[] columnNames = this.columnNames;
        Boolean[] columnChanged = this.columnChanged;
        Object[] columnValue = this.columnValue;
        int idx = -1;
        if (!this.duplicateColumns.isEmpty() && this.duplicateColumns.contains(name)) {
            int length = this.length;
            for (int i = 0; i < length; ++i) {
                if (columnChanged[i] != null || !ObjectUtilities.equal((Object)name, (Object)columnNames[i])) continue;
                idx = i;
                break;
            }
            if (idx < 0) {
                idx = o;
            }
        } else {
            idx = o;
        }
        columnNames[idx] = name;
        Object oldValue = columnValue[idx];
        columnValue[idx] = value;
        if (columnChanged[idx] == null) {
            columnChanged[idx] = ObjectUtilities.equal((Object)oldValue, (Object)value) ? Boolean.FALSE : Boolean.TRUE;
        }
    }

    private void addColumn(String name, Object value) {
        if (!this.modifiableNameCache) {
            this.columnNames = (String[])this.columnNames.clone();
            this.nameCache = (HashMap)this.nameCache.clone();
            this.modifiableNameCache = true;
        }
        this.ensureCapacity(this.length + 1);
        this.columnNames[this.length] = name;
        this.columnValue[this.length] = value;
        Integer o = (Integer)this.nameCache.get(name);
        if (o == null) {
            this.columnPrev[this.length] = -1;
        } else {
            this.columnPrev[this.length] = o;
            this.duplicateColumns.add(name);
        }
        this.columnOldValue[this.length] = null;
        this.columnChanged[this.length] = Boolean.TRUE;
        this.nameCache.put(name, IntegerCache.getInteger(this.length));
        ++this.length;
    }

    private void ensureCapacity(int requestedSize) {
        int capacity = this.columnNames.length;
        if (capacity > requestedSize) {
            return;
        }
        int newSize = Math.max(capacity << 1, requestedSize + 10);
        String[] newColumnNames = new String[newSize];
        System.arraycopy(this.columnNames, 0, newColumnNames, 0, this.length);
        this.columnNames = newColumnNames;
        Boolean[] newColumnChanged = new Boolean[newSize];
        System.arraycopy(this.columnChanged, 0, newColumnChanged, 0, this.length);
        this.columnChanged = newColumnChanged;
        int[] newColumnPrev = new int[newSize];
        System.arraycopy(this.columnPrev, 0, newColumnPrev, 0, this.length);
        this.columnPrev = newColumnPrev;
        Object[] newColumnValue = new Object[newSize];
        System.arraycopy(this.columnValue, 0, newColumnValue, 0, this.length);
        this.columnValue = newColumnValue;
        Object[] newOldColumnValue = new Object[newSize];
        System.arraycopy(this.columnOldValue, 0, newOldColumnValue, 0, this.length);
        this.columnOldValue = newOldColumnValue;
    }
}

