/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.states.CascadingDataFactory;
import org.pentaho.reporting.engine.classic.core.states.EmptyDataFactory;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.datarow.ExpressionDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.FastGlobalView;
import org.pentaho.reporting.engine.classic.core.states.datarow.ImportedVariablesDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRowChangeEvent;
import org.pentaho.reporting.engine.classic.core.states.datarow.PaddingDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.ProcessingDataSchemaCompiler;
import org.pentaho.reporting.engine.classic.core.states.datarow.ReportDataRow;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;

public final class GlobalMasterRow
implements MasterDataRow {
    private ReportEnvironmentDataRow environmentDataRow;
    private DataFactory dataFactory;
    private ReportDataRow reportDataRow;
    private ExpressionDataRow expressionDataRow;
    private ParameterDataRow parameterDataRow;
    private MasterDataRow parentRow;
    private FastGlobalView globalView;
    private ImportedVariablesDataRow importedDataRow;
    private DataSchemaDefinition schemaDefinition;
    private ProcessingDataSchemaCompiler schemaCompiler;
    private DataSchema dataSchema;
    private PaddingDataRow paddingDataRow;
    private int prePaddingCount;
    private ResourceBundleFactory resourceBundleFactory;
    private OutputProcessorMetaData outputProcessorMetaData;
    private ParameterDefinitionEntry[] parameterDefinitionEntries;

    private GlobalMasterRow() {
    }

    public static GlobalMasterRow createReportRow(ProcessingContext reportContext, DataSchemaDefinition schemaDefinition, ParameterDataRow parameterDataRow, ParameterDefinitionEntry[] parameterDefinitionEntries, boolean includeStucturalProcessing) {
        if (reportContext == null) {
            throw new NullPointerException();
        }
        if (schemaDefinition == null) {
            throw new NullPointerException();
        }
        if (parameterDataRow == null) {
            throw new NullPointerException();
        }
        GlobalMasterRow gmr = new GlobalMasterRow();
        gmr.globalView = new FastGlobalView();
        gmr.expressionDataRow = new ExpressionDataRow((MasterDataRow)gmr, reportContext, includeStucturalProcessing);
        gmr.schemaDefinition = schemaDefinition;
        gmr.dataFactory = new EmptyDataFactory();
        gmr.resourceBundleFactory = reportContext.getResourceBundleFactory();
        gmr.outputProcessorMetaData = reportContext.getOutputProcessorMetaData();
        DefaultDataAttributeContext dac = new DefaultDataAttributeContext(gmr.outputProcessorMetaData, gmr.getResourceBundleFactory().getLocale());
        gmr.schemaCompiler = new ProcessingDataSchemaCompiler(schemaDefinition, dac, reportContext.getResourceManager(), null);
        gmr.dataSchema = null;
        gmr.parameterDefinitionEntries = parameterDefinitionEntries;
        gmr.setEnvironmentDataRow(new ReportEnvironmentDataRow(reportContext.getEnvironment()));
        gmr.setParameterDataRow(parameterDataRow);
        return gmr;
    }

    public MasterDataRow deriveSubDataRow(ProcessingContext reportContext, DataFactory reportFactory, ParameterDataRow parameterDataRow, ParameterDefinitionEntry[] parameterDefinitionEntries, ResourceBundleFactory resourceBundleFactory) {
        if (reportContext == null) {
            throw new NullPointerException();
        }
        if (reportFactory == null) {
            throw new NullPointerException();
        }
        if (resourceBundleFactory == null) {
            throw new NullPointerException();
        }
        if (parameterDataRow == null) {
            throw new NullPointerException();
        }
        GlobalMasterRow gmr = new GlobalMasterRow();
        gmr.outputProcessorMetaData = this.outputProcessorMetaData;
        gmr.schemaDefinition = this.schemaDefinition;
        gmr.schemaCompiler = this.schemaCompiler;
        gmr.globalView = new FastGlobalView();
        gmr.expressionDataRow = new ExpressionDataRow((MasterDataRow)gmr, reportContext, this.expressionDataRow.isIncludeStructuralProcessing());
        gmr.parentRow = this;
        gmr.dataSchema = null;
        gmr.resourceBundleFactory = resourceBundleFactory;
        gmr.parameterDefinitionEntries = parameterDefinitionEntries;
        CascadingDataFactory dataFactory = new CascadingDataFactory();
        dataFactory.add(reportFactory);
        dataFactory.add(this.dataFactory);
        gmr.dataFactory = dataFactory;
        gmr.setParameterDataRow(parameterDataRow);
        gmr.setEnvironmentDataRow(this.environmentDataRow);
        return gmr;
    }

    public MasterDataRow deriveWithQueryData(ReportDataRow tableData) {
        if (tableData == null) {
            throw new NullPointerException();
        }
        GlobalMasterRow derived = (GlobalMasterRow)this.derive();
        derived.setReportDataRow(tableData);
        return derived;
    }

    public MasterDataRow deriveWithReturnFromQuery() {
        GlobalMasterRow derived = (GlobalMasterRow)this.derive();
        derived.setReportDataRow(null);
        derived.setParameterDataRow(null);
        return derived;
    }

    public ParameterDefinitionEntry[] getParameterDefinitionEntries() {
        if (this.parameterDefinitionEntries == null) {
            return null;
        }
        return (ParameterDefinitionEntry[])this.parameterDefinitionEntries.clone();
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public DataSchema getDataSchema() {
        if (this.dataSchema == null) {
            try {
                this.dataSchema = this.schemaCompiler.compile(this, this.environmentDataRow.getEnvironment());
            }
            catch (ReportDataFactoryException re) {
                throw new IllegalStateException("Failed to compile data-schema - aborting report processing", (Throwable)((Object)re));
            }
        }
        return this.dataSchema;
    }

    public ReportDataRow getReportDataRow() {
        return this.reportDataRow;
    }

    public void setReportDataRow(ReportDataRow reportDataRow) {
        if (this.reportDataRow != null) {
            int dataColCount = this.reportDataRow.getColumnCount();
            for (int i = dataColCount - 1; i >= 0; --i) {
                String columnName = this.reportDataRow.getColumnName(i);
                if (columnName == null) continue;
                this.globalView.removeColumn(columnName);
            }
        }
        this.reportDataRow = reportDataRow;
        if (reportDataRow != null) {
            boolean readable = reportDataRow.isReadable();
            int dataColCount = reportDataRow.getColumnCount();
            for (int i = 0; i < dataColCount; ++i) {
                String columnName = reportDataRow.getColumnName(i);
                if (columnName == null) continue;
                if (readable) {
                    Object columnValue = reportDataRow.get(i);
                    this.globalView.putField(columnName, columnValue, false);
                    continue;
                }
                this.globalView.putField(columnName, null, false);
            }
        }
        this.dataSchema = null;
    }

    public ExpressionDataRow getExpressionDataRow() {
        return this.expressionDataRow;
    }

    public ReportEnvironmentDataRow getEnvironmentDataRow() {
        return this.environmentDataRow;
    }

    public void setEnvironmentDataRow(ReportEnvironmentDataRow environmentDataRow) {
        String columnName;
        int i;
        String[] columnNames;
        if (this.environmentDataRow != null) {
            columnNames = this.environmentDataRow.getColumnNames();
            for (i = 0; i < columnNames.length; ++i) {
                columnName = columnNames[i];
                if (columnName == null) continue;
                this.globalView.removeColumn(columnName);
            }
        }
        this.environmentDataRow = environmentDataRow;
        if (environmentDataRow != null) {
            columnNames = environmentDataRow.getColumnNames();
            for (i = 0; i < columnNames.length; ++i) {
                columnName = columnNames[i];
                if (columnName == null) continue;
                Object columnValue = environmentDataRow.get(columnName);
                this.globalView.putField(columnName, columnValue, false);
            }
        }
        this.dataSchema = null;
    }

    public ParameterDataRow getParameterDataRow() {
        return this.parameterDataRow;
    }

    public void setParameterDataRow(ParameterDataRow parameterDataRow) {
        String columnName;
        int i;
        String[] columnNames;
        if (this.parameterDataRow != null) {
            columnNames = this.parameterDataRow.getColumnNames();
            for (i = 0; i < columnNames.length; ++i) {
                columnName = columnNames[i];
                if (columnName == null) continue;
                this.globalView.removeColumn(columnName);
            }
        }
        this.parameterDataRow = parameterDataRow;
        if (parameterDataRow != null) {
            columnNames = parameterDataRow.getColumnNames();
            for (i = 0; i < columnNames.length; ++i) {
                columnName = columnNames[i];
                if (columnName == null) continue;
                Object columnValue = parameterDataRow.get(columnName);
                this.globalView.putField(columnName, columnValue, false);
            }
        }
        this.dataSchema = null;
    }

    public DataRow getGlobalView() {
        return this.globalView;
    }

    public void dataRowChanged(MasterDataRowChangeEvent chEvent) {
        int type = chEvent.getType();
        if (type == 1) {
            this.globalView.putField(chEvent.getColumnName(), chEvent.getColumnValue(), false);
        } else if (type == 3) {
            this.globalView.putField(chEvent.getColumnName(), chEvent.getColumnValue(), true);
        } else if (type == 2) {
            this.globalView.removeColumn(chEvent.getColumnName());
        }
    }

    private void updateGlobalView() {
        if (this.parameterDataRow != null) {
            String[] columnNames = this.parameterDataRow.getColumnNames();
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                if (columnName == null) continue;
                Object columnValue = this.parameterDataRow.get(columnName);
                this.globalView.putField(columnName, columnValue, true);
            }
        }
        if (this.reportDataRow != null) {
            int dataColCount = this.reportDataRow.getColumnCount();
            boolean readable = this.reportDataRow.isReadable();
            for (int i = 0; i < dataColCount; ++i) {
                String columnName = this.reportDataRow.getColumnName(i);
                if (columnName == null) continue;
                if (readable) {
                    Object columnValue = this.reportDataRow.get(i);
                    this.globalView.putField(columnName, columnValue, true);
                    continue;
                }
                this.globalView.putField(columnName, null, true);
            }
        }
    }

    public boolean isAdvanceable() {
        if (this.paddingDataRow != null) {
            if (this.prePaddingCount > 0) {
                return true;
            }
            if (this.paddingDataRow.getPrePaddingRows(this.globalView) > 0) {
                return true;
            }
            if (this.paddingDataRow.getPostPaddingRows(this.globalView) > 0) {
                return true;
            }
        }
        if (this.reportDataRow != null) {
            int colsToGo;
            if (this.reportDataRow.isAdvanceable()) {
                return true;
            }
            if (this.paddingDataRow != null && (colsToGo = this.paddingDataRow.getCrosstabColumnCount() - this.paddingDataRow.getCurrentCursorPosition() - 1) > 0) {
                this.prePaddingCount = colsToGo;
                return true;
            }
        }
        return false;
    }

    public MasterDataRow derive() {
        GlobalMasterRow o = new GlobalMasterRow();
        o.environmentDataRow = this.environmentDataRow;
        o.outputProcessorMetaData = this.outputProcessorMetaData;
        o.prePaddingCount = this.prePaddingCount;
        o.paddingDataRow = this.paddingDataRow;
        o.dataFactory = this.dataFactory;
        o.dataSchema = this.dataSchema;
        o.schemaCompiler = this.schemaCompiler;
        o.schemaDefinition = this.schemaDefinition;
        o.globalView = this.globalView.derive();
        o.reportDataRow = this.reportDataRow;
        o.parameterDataRow = this.parameterDataRow;
        o.resourceBundleFactory = this.resourceBundleFactory;
        o.expressionDataRow = this.expressionDataRow.derive(o, false);
        if (this.parentRow != null) {
            o.parentRow = this.parentRow.derive();
        }
        o.importedDataRow = this.importedDataRow;
        return o;
    }

    public void setImportedDataRow(ImportedVariablesDataRow dataRow) {
        String columnName;
        int i;
        String[] columnNames;
        if (this.importedDataRow != null) {
            columnNames = this.importedDataRow.getColumnNames();
            for (i = 0; i < columnNames.length; ++i) {
                columnName = columnNames[i];
                if (columnName == null) continue;
                this.globalView.removeColumn(columnName);
            }
        }
        this.importedDataRow = dataRow;
        if (this.importedDataRow != null) {
            columnNames = this.importedDataRow.getColumnNames();
            for (i = 0; i < columnNames.length; ++i) {
                columnName = columnNames[i];
                if (columnName == null) continue;
                Object columnValue = this.importedDataRow.get(columnName);
                this.globalView.putField(columnName, columnValue, false);
            }
        }
        this.dataSchema = null;
    }

    public ImportedVariablesDataRow getImportedDataRow() {
        return this.importedDataRow;
    }

    public MasterDataRow getParentDataRow() {
        return this.parentRow;
    }

    public MasterDataRow advance() {
        return this.advanceRecursively(false, null);
    }

    public MasterDataRow advanceRecursively(boolean deepTraversingOnly, MasterDataRow subReportRow) {
        GlobalMasterRow dataRow = new GlobalMasterRow();
        dataRow.environmentDataRow = this.environmentDataRow;
        dataRow.outputProcessorMetaData = this.outputProcessorMetaData;
        dataRow.globalView = !deepTraversingOnly ? this.globalView.advance() : this.globalView.derive();
        dataRow.dataSchema = this.dataSchema;
        dataRow.dataFactory = this.dataFactory;
        dataRow.schemaCompiler = this.schemaCompiler;
        dataRow.schemaDefinition = this.schemaDefinition;
        dataRow.parameterDataRow = this.parameterDataRow;
        dataRow.resourceBundleFactory = this.resourceBundleFactory;
        boolean needActivate = false;
        if (!deepTraversingOnly && this.paddingDataRow != null) {
            dataRow.paddingDataRow = this.paddingDataRow.advance();
            dataRow.prePaddingCount = this.prePaddingCount;
        }
        if (!deepTraversingOnly && this.reportDataRow != null) {
            if (this.prePaddingCount > 0) {
                --dataRow.prePaddingCount;
                dataRow.reportDataRow = this.reportDataRow;
                needActivate = true;
            } else {
                dataRow.reportDataRow = this.reportDataRow.advance();
            }
        } else {
            dataRow.reportDataRow = this.reportDataRow;
        }
        dataRow.updateGlobalView();
        if (this.expressionDataRow != null) {
            dataRow.expressionDataRow = this.expressionDataRow.derive(dataRow, true);
        }
        if (this.parentRow != null) {
            dataRow.parentRow = this.parentRow.advanceRecursively(true, dataRow);
        }
        if (this.importedDataRow != null && subReportRow != null) {
            dataRow.importedDataRow = this.importedDataRow.refresh(subReportRow.getGlobalView(), subReportRow.getDataSchema());
            String[] columnNames = dataRow.importedDataRow.getColumnNames();
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                if (columnName == null) continue;
                Object columnValue = dataRow.importedDataRow.get(columnName);
                dataRow.globalView.putField(columnName, columnValue, true);
            }
        }
        if (!deepTraversingOnly && this.paddingDataRow != null) {
            if (needActivate) {
                dataRow.paddingDataRow.activate(dataRow);
            } else {
                dataRow.prePaddingCount = dataRow.paddingDataRow.getPostPaddingRows(dataRow.getGlobalView());
                if (dataRow.prePaddingCount > 0) {
                    dataRow.paddingDataRow.activate(dataRow);
                }
            }
        }
        return dataRow;
    }

    public void fireReportEvent(ReportEvent event) {
        if (this.expressionDataRow != null) {
            this.expressionDataRow.fireReportEvent(event);
        }
        if ((event.getType() & 0x8000000) == 0x8000000) {
            return;
        }
        if (this.parentRow != null) {
            ReportState parentState = event.getState().getParentSubReportState();
            ReportEvent deepEvent = parentState == null ? event : new ReportEvent(parentState, event.getState(), event.getType() | 0x4000000);
            this.parentRow.fireReportEvent(deepEvent);
            this.parentRow.updateImportedVariables(this.getGlobalView(), this.getDataSchema());
        }
    }

    public void updateImportedVariables(DataRow globalView, DataSchema dataSchema) {
        if (this.importedDataRow == null) {
            return;
        }
        this.importedDataRow = this.importedDataRow.refresh(globalView, dataSchema);
        String[] columnNames = this.importedDataRow.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            if (columnName == null) continue;
            Object columnValue = this.importedDataRow.get(columnName);
            this.globalView.putField(columnName, columnValue, true);
        }
    }

    public boolean isPrepareEventListener() {
        if (this.parentRow != null && this.parentRow.isPrepareEventListener()) {
            return true;
        }
        if (this.expressionDataRow == null) {
            return false;
        }
        return this.expressionDataRow.isPrepareEventListener();
    }

    public MasterDataRow startCrosstabMode(CrosstabSpecification crosstabSpecification) {
        GlobalMasterRow retval = (GlobalMasterRow)this.derive();
        retval.paddingDataRow = new PaddingDataRow(crosstabSpecification);
        int prePaddingRows = retval.paddingDataRow.getPrePaddingRows(retval.getGlobalView());
        if (prePaddingRows > 0) {
            retval.paddingDataRow.activate(retval);
            retval.prePaddingCount = prePaddingRows;
        }
        return retval;
    }

    public MasterDataRow endCrosstabMode() {
        GlobalMasterRow retval = (GlobalMasterRow)this.derive();
        retval.paddingDataRow = null;
        return retval;
    }

    public MasterDataRow resetRowCursor() {
        GlobalMasterRow retval = (GlobalMasterRow)this.derive();
        if (retval.paddingDataRow != null) {
            retval.paddingDataRow = retval.paddingDataRow.resetRowCursor();
            int prePaddingRows = retval.paddingDataRow.getPrePaddingRows(retval.getGlobalView());
            if (prePaddingRows > 0) {
                retval.paddingDataRow.activate(retval);
                retval.prePaddingCount = prePaddingRows;
            }
        }
        return retval;
    }

    public int getPrePaddingCount() {
        return this.prePaddingCount;
    }

    public MasterDataRow clearExportedParameters() {
        GlobalMasterRow derived = (GlobalMasterRow)this.derive();
        derived.setImportedDataRow(null);
        derived.resetDataSchema();
        return derived;
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public void resetDataSchema() {
        this.dataSchema = null;
    }

    public GlobalMasterRow rebuild() {
        if (this.globalView.getColumnNames().length == 0) {
            return this;
        }
        if (this.parentRow != null) {
            throw new IllegalStateException("This should be at the beginning of the master-report processing. No parent allowed.");
        }
        if (this.reportDataRow != null) {
            throw new IllegalStateException("This should be at the beginning of the master-report processing. No report-data allowed.");
        }
        GlobalMasterRow gmr = (GlobalMasterRow)this.derive();
        gmr.dataSchema = null;
        gmr.globalView = new FastGlobalView();
        gmr.parameterDataRow = null;
        gmr.setParameterDataRow(this.getParameterDataRow());
        return gmr;
    }

    public MasterDataRow updateDataSchema(DataSchemaDefinition dataSchemaDefinition) {
        if (dataSchemaDefinition == null) {
            throw new NullPointerException();
        }
        DefaultDataAttributeContext dac = new DefaultDataAttributeContext(this.outputProcessorMetaData, this.resourceBundleFactory.getLocale());
        GlobalMasterRow gmr = (GlobalMasterRow)this.derive();
        gmr.schemaDefinition = dataSchemaDefinition;
        gmr.schemaCompiler = new ProcessingDataSchemaCompiler(dataSchemaDefinition, dac, this.schemaCompiler.getResourceManager(), this.schemaCompiler.getGlobalDefaults());
        gmr.dataSchema = null;
        return gmr;
    }

    public DataSchemaDefinition getDataSchemaDefinition() {
        return this.schemaDefinition;
    }

    public void refresh() {
        this.updateGlobalView();
        if (this.expressionDataRow != null) {
            this.expressionDataRow.refresh();
        }
    }
}

