/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;

public class ImportedVariablesDataRow
extends StaticDataRow {
    private HashMap dataAttributes;
    private String[] outerNames;
    private String[] innerNames;

    public ImportedVariablesDataRow(MasterDataRow innerRow) {
        if (innerRow == null) {
            throw new NullPointerException();
        }
        DataRow globalView = innerRow.getGlobalView();
        String[] names = globalView.getColumnNames();
        int cols = names.length;
        this.dataAttributes = new HashMap();
        this.outerNames = new String[cols];
        this.innerNames = this.outerNames;
        Object[] values = new Object[cols];
        DataSchema dataSchema = innerRow.getDataSchema();
        for (int i = 0; i < cols; ++i) {
            String name = names[i];
            if (name == null) {
                throw new IllegalStateException("Every column must have a name.");
            }
            this.outerNames[i] = name;
            values[i] = globalView.get(name);
            this.dataAttributes.put(name, dataSchema.getAttributes(name));
        }
        this.setData(this.outerNames, values);
    }

    public ImportedVariablesDataRow(MasterDataRow innerRow, ParameterMapping[] parameterMappings) {
        if (innerRow == null) {
            throw new NullPointerException();
        }
        if (parameterMappings == null) {
            throw new NullPointerException();
        }
        DataRow globalView = innerRow.getGlobalView();
        int cols = parameterMappings.length;
        this.dataAttributes = new HashMap();
        this.outerNames = new String[cols];
        this.innerNames = this.outerNames;
        Object[] values = new Object[cols];
        DataSchema dataSchema = innerRow.getDataSchema();
        for (int i = 0; i < cols; ++i) {
            ParameterMapping mapping = parameterMappings[i];
            String name = mapping.getAlias();
            if (name == null) {
                throw new IllegalStateException("Every column must have a name.");
            }
            this.outerNames[i] = name;
            values[i] = globalView.get(name);
            this.dataAttributes.put(mapping.getName(), dataSchema.getAttributes(name));
        }
        this.setData(this.outerNames, values);
    }

    protected ImportedVariablesDataRow(ImportedVariablesDataRow dataRow) {
        super(dataRow);
        this.outerNames = dataRow.outerNames;
        this.innerNames = dataRow.innerNames;
        this.dataAttributes = (HashMap)dataRow.dataAttributes.clone();
    }

    public ImportedVariablesDataRow refresh(DataRow globalView, DataSchema dataSchema) {
        if (globalView == null) {
            throw new NullPointerException();
        }
        if (dataSchema == null) {
            throw new NullPointerException();
        }
        int length = this.innerNames.length;
        Object[] values = new Object[length];
        for (int i = 0; i < length; ++i) {
            String name = this.innerNames[i];
            values[i] = globalView.get(name);
            this.dataAttributes.put(this.outerNames[i], dataSchema.getAttributes(name));
        }
        ImportedVariablesDataRow idr = new ImportedVariablesDataRow(this);
        idr.setData(this.outerNames, values);
        return idr;
    }

    public DataAttributes getAttributes(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (DataAttributes)this.dataAttributes.get(name);
    }
}

