/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRowChangeEvent;

public class PaddingDataRow {
    private static final Log logger = LogFactory.getLog(PaddingDataRow.class);
    private int currentCursorPosition;
    private CrosstabSpecification crosstabSpecification;
    private Object[] key;
    private String[] columnNames;

    public PaddingDataRow(PaddingDataRow dataRow) {
        this.currentCursorPosition = dataRow.currentCursorPosition;
        this.crosstabSpecification = dataRow.crosstabSpecification;
        this.key = (Object[])dataRow.key.clone();
        this.columnNames = dataRow.columnNames;
    }

    public PaddingDataRow(CrosstabSpecification crosstabSpecification) {
        if (crosstabSpecification == null) {
            throw new NullPointerException();
        }
        this.crosstabSpecification = crosstabSpecification;
        this.columnNames = this.crosstabSpecification.getColumnNames();
        this.key = new Object[this.columnNames.length];
    }

    public int getPrePaddingRows(DataRow globalView) {
        if (this.key.length == 0) {
            return 0;
        }
        for (int i = 0; i < this.key.length; ++i) {
            this.key[i] = globalView.get(this.columnNames[i]);
        }
        int computedPosition = this.crosstabSpecification.indexOf(this.currentCursorPosition, this.key);
        if (computedPosition < 0) {
            return 0;
        }
        return computedPosition - this.currentCursorPosition;
    }

    public int getCurrentCursorPosition() {
        return this.currentCursorPosition;
    }

    public int getCrosstabColumnCount() {
        return this.crosstabSpecification.size();
    }

    private String printKey(Object[] data) {
        StringBuffer s = new StringBuffer("{");
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(data[i]);
        }
        return s + "}";
    }

    public int getPostPaddingRows(DataRow globalView) {
        if (this.key.length == 0) {
            return 0;
        }
        for (int i = 0; i < this.key.length; ++i) {
            this.key[i] = globalView.get(this.columnNames[i]);
        }
        int computedPosition = this.crosstabSpecification.indexOf(this.currentCursorPosition, this.key);
        if (computedPosition < 0) {
            return this.crosstabSpecification.size() - this.currentCursorPosition - 1;
        }
        return computedPosition - this.currentCursorPosition;
    }

    public PaddingDataRow advance() {
        PaddingDataRow dataRow = new PaddingDataRow(this);
        ++dataRow.currentCursorPosition;
        return dataRow;
    }

    public void activate(MasterDataRow dataRow) {
        if (this.key.length == 0) {
            return;
        }
        Object[] currentColumn = this.crosstabSpecification.getKeyAt(this.currentCursorPosition);
        for (int i = 0; i < this.columnNames.length; ++i) {
            MasterDataRowChangeEvent chEvent = new MasterDataRowChangeEvent(3, this.columnNames[i], currentColumn[i]);
            logger.debug((Object)("Messing around with Column: " + this.columnNames[i] + " = " + currentColumn[i]));
            dataRow.dataRowChanged(chEvent);
        }
    }

    public PaddingDataRow resetRowCursor() {
        PaddingDataRow dataRow = new PaddingDataRow(this);
        dataRow.currentCursorPosition = 0;
        return dataRow;
    }
}

