/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.states.datarow.ExpressionDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.ImportedVariablesDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.ReportDataRow;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaCompiler;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaRule;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ProcessingDataSchemaCompiler
extends DataSchemaCompiler {
    private static final Log logger = LogFactory.getLog(ProcessingDataSchemaCompiler.class);
    private ResourceManager resourceManager;
    private DataSchemaDefinition globalDefaults;

    public ProcessingDataSchemaCompiler(DataSchemaDefinition reportSchemaDefinition, DataAttributeContext context, ResourceManager resourceManager, DataSchemaDefinition globalDefaults) {
        super(reportSchemaDefinition, context, resourceManager);
        this.resourceManager = resourceManager;
        this.globalDefaults = globalDefaults;
    }

    protected DataSchemaDefinition parseGlobalDefaults(ResourceManager resourceManager) {
        if (this.globalDefaults == null) {
            this.globalDefaults = super.parseGlobalDefaults(resourceManager);
        }
        return this.globalDefaults;
    }

    public DataSchemaDefinition getGlobalDefaults() {
        return this.globalDefaults;
    }

    public DataSchema compile(MasterDataRow masterRow, ReportEnvironment reportEnvironment) throws ReportDataFactoryException {
        if (masterRow == null) {
            throw new NullPointerException();
        }
        if (!this.isInitialized()) {
            this.init();
        }
        DefaultDataAttributes globalAttributes = this.getGlobalAttributes();
        DataSchemaRule[] indirectRules = this.getIndirectRules();
        DataSchemaRule[] directRules = this.getDirectRules();
        DataAttributeContext context = this.getContext();
        ParameterDataRow parameters = masterRow.getParameterDataRow();
        ExpressionDataRow expressionsRow = masterRow.getExpressionDataRow();
        ReportDataRow massDataRow = masterRow.getReportDataRow();
        ImportedVariablesDataRow importedDataRow = masterRow.getImportedDataRow();
        DefaultDataSchema defaultDataSchema = new DefaultDataSchema();
        if (parameters != null) {
            MasterDataRow parentRow = masterRow.getParentDataRow();
            if (parentRow == null) {
                this.processParameters(parameters, null, reportEnvironment, globalAttributes, indirectRules, directRules, defaultDataSchema);
            } else {
                String[] parameterNames = parameters.getParentNames();
                String[] innerNames = parameters.getColumnNames();
                for (int i = 0; i < parameterNames.length; ++i) {
                    String name = parameterNames[i];
                    DataAttributes attributes = parentRow.getDataSchema().getAttributes(name);
                    defaultDataSchema.setAttributes(innerNames[i], attributes);
                }
            }
        }
        Expression[] expressions = expressionsRow.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            Expression expression = expressions[i];
            String name = expression.getName();
            if (name == null) continue;
            DefaultDataAttributes computedParameterDataAttributes = new DefaultDataAttributes();
            computedParameterDataAttributes.merge(globalAttributes, context);
            computedParameterDataAttributes.merge(new DataSchemaCompiler.ExpressionsDataAttributes(expression), context);
            this.applyRules(indirectRules, directRules, computedParameterDataAttributes);
            defaultDataSchema.setAttributes(name, computedParameterDataAttributes);
        }
        if (massDataRow != null) {
            DataSchemaCompiler.GenericDataAttributes parameterDataAttributes = this.getTableDataAttributes();
            TableModel data = massDataRow.getReportData();
            if (!(data instanceof MetaTableModel)) {
                int count = data.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    String colName = data.getColumnName(i);
                    parameterDataAttributes.setup(colName, data.getColumnClass(i), "table", colName, globalAttributes);
                    DefaultDataAttributes computedParameterDataAttributes = new DefaultDataAttributes();
                    computedParameterDataAttributes.merge(parameterDataAttributes, context);
                    this.applyRules(indirectRules, directRules, computedParameterDataAttributes);
                    defaultDataSchema.setAttributes(colName, computedParameterDataAttributes);
                }
            } else {
                MetaTableModel mt = (MetaTableModel)data;
                DefaultDataAttributes tableGlobalAttributes = new DefaultDataAttributes();
                tableGlobalAttributes.merge(globalAttributes, context);
                tableGlobalAttributes.merge(mt.getTableAttributes(), context);
                try {
                    defaultDataSchema.setTableAttributes(tableGlobalAttributes);
                }
                catch (CloneNotSupportedException e) {
                    logger.warn((Object)"Unable to copy global data-attributes", (Throwable)e);
                }
                int count = data.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    String colName = data.getColumnName(i);
                    DefaultDataAttributes computedParameterDataAttributes = new DefaultDataAttributes();
                    computedParameterDataAttributes.merge(tableGlobalAttributes, context);
                    computedParameterDataAttributes.merge(mt.getColumnAttributes(i), context);
                    parameterDataAttributes.setup(colName, data.getColumnClass(i), "table", null, EmptyDataAttributes.INSTANCE);
                    computedParameterDataAttributes.merge(parameterDataAttributes, context);
                    this.applyRules(indirectRules, directRules, computedParameterDataAttributes);
                    defaultDataSchema.setAttributes(colName, computedParameterDataAttributes);
                }
            }
        }
        if (importedDataRow != null) {
            String[] columnNames = importedDataRow.getColumnNames();
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                defaultDataSchema.setAttributes(columnName, importedDataRow.getAttributes(columnName));
            }
        }
        return defaultDataSchema;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }
}

