/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabFactHandler;
import org.pentaho.reporting.engine.classic.core.states.process.InlineSubreportProcessor;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class BeginCrosstabColumnAxisHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new BeginCrosstabColumnAxisHandler();

    private BeginCrosstabColumnAxisHandler() {
    }

    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState next = state.deriveForAdvance();
        next.enterGroup();
        next.fireReportEvent();
        next.enterPresentationGroup();
        Group group = next.getReport().getGroup(next.getCurrentGroupIndex());
        return InlineSubreportProcessor.processInline(next, group.getHeader());
    }

    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        Group group = next.getReport().getGroup(next.getCurrentGroupIndex());
        GroupBody body = group.getBody();
        if (body instanceof CrosstabColumnGroupBody) {
            next.setAdvanceHandler(HANDLER);
        } else if (body instanceof GroupDataBody) {
            next.setAdvanceHandler(BeginCrosstabFactHandler.HANDLER);
        } else {
            throw new IllegalStateException("This report is totally messed up!");
        }
        GroupHeader rootLevelBand = group.getHeader();
        return InlineSubreportProcessor.process(next, rootLevelBand);
    }

    public boolean isFinish() {
        return false;
    }

    public int getEventCode() {
        return 0x810008;
    }

    public boolean isRestoreHandler() {
        return false;
    }
}

