/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabProcessorFunction;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.crosstab.DummyCrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabOtherAxisHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabRowAxisHandler;
import org.pentaho.reporting.engine.classic.core.states.process.InlineSubreportProcessor;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class BeginCrosstabHandler
implements AdvanceHandler {
    public static final BeginCrosstabHandler HANDLER = new BeginCrosstabHandler();

    private BeginCrosstabHandler() {
    }

    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState next = state.deriveForAdvance();
        next.enterGroup();
        next.fireReportEvent();
        next.enterPresentationGroup();
        CrosstabSpecification cs = this.findCrosstabSpecification(next);
        DefaultFlowController controller = next.getFlowController().startCrosstabMode(cs);
        next.setFlowController(controller);
        Group group = next.getReport().getGroup(next.getCurrentGroupIndex());
        return InlineSubreportProcessor.processInline(next, group.getHeader());
    }

    private CrosstabSpecification findCrosstabSpecification(ProcessState next) throws ReportProcessingException {
        StructureFunction[] functions = next.getLayoutProcess().getCollectionFunctions();
        for (int i = 0; i < functions.length; ++i) {
            StructureFunction function = functions[i];
            if (!(function instanceof CrosstabProcessorFunction)) continue;
            CrosstabSpecification cs = (CrosstabSpecification)function.getValue();
            if (cs == null) {
                return new DummyCrosstabSpecification(next.getProcessKey());
            }
            return cs;
        }
        throw new ReportProcessingException("Failed to locate crosstab-spec, cannot continue.");
    }

    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        Group group = next.getReport().getGroup(next.getCurrentGroupIndex());
        GroupBody body = group.getBody();
        if (body instanceof CrosstabRowGroupBody) {
            next.setAdvanceHandler(BeginCrosstabRowAxisHandler.HANDLER);
        } else if (body instanceof CrosstabOtherGroupBody) {
            next.setAdvanceHandler(BeginCrosstabOtherAxisHandler.HANDLER);
        } else {
            throw new IllegalStateException("This report is totally messed up!");
        }
        GroupHeader rootLevelBand = group.getHeader();
        return InlineSubreportProcessor.process(next, rootLevelBand);
    }

    public boolean isFinish() {
        return false;
    }

    public int getEventCode() {
        return 0x110008;
    }

    public boolean isRestoreHandler() {
        return false;
    }
}

