/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginDetailsHandler;
import org.pentaho.reporting.engine.classic.core.states.process.InlineSubreportProcessor;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class BeginGroupHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new BeginGroupHandler();

    private BeginGroupHandler() {
    }

    public int getEventCode() {
        return 8;
    }

    private boolean hasMoreGroups(ProcessState state) {
        return state.getCurrentGroupIndex() < state.getReport().getGroupCount() - 1;
    }

    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState next = state.deriveForAdvance();
        next.enterGroup();
        next.fireReportEvent();
        next.enterPresentationGroup();
        Group group = next.getReport().getGroup(next.getCurrentGroupIndex());
        return InlineSubreportProcessor.processInline(next, group.getHeader());
    }

    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        if (!this.hasMoreGroups(next)) {
            next.setAdvanceHandler(BeginDetailsHandler.HANDLER);
        } else {
            Group nextGroup = next.getReport().getGroup(next.getCurrentGroupIndex() + 1);
            if (nextGroup instanceof CrosstabGroup) {
                next.setAdvanceHandler(BeginCrosstabHandler.HANDLER);
            }
        }
        Group group = next.getReport().getGroup(next.getCurrentGroupIndex());
        GroupHeader rootLevelBand = group.getHeader();
        return InlineSubreportProcessor.process(next, rootLevelBand);
    }

    public boolean isFinish() {
        return false;
    }

    public boolean isRestoreHandler() {
        return false;
    }
}

